/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.edit.parts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IPapyrusNodeFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SelectableBorderedNodeFigure;
import org.eclipse.papyrus.uml.diagram.common.editparts.NamedElementEditPart;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeNodeLabelDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.BorderItemResizableEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.PapyrusCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.policies.CustomInteractionCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.policies.TimingDiagramDragDropEditPolicy;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.CustomInteractionRectangleFigure;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.GateEditPart;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.InteractionCompartmentEditPartTN;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.InteractionNameEditPart;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.TimeRulerCompartmentEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.edit.policies.InteractionNodeItemSemanticEditPolicyTN;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.timing.providers.UMLElementTypes;
import org.eclipse.swt.graphics.Color;

public class InteractionEditPartTN
extends NamedElementEditPart {
    public static final int VISUAL_ID = 2;
    protected IFigure contentPane;
    protected IFigure primaryShape;

    public InteractionEditPartTN(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        this.installEditPolicy("CreationPolicy", (EditPolicy)new PapyrusCreationEditPolicy());
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new InteractionNodeItemSemanticEditPolicyTN());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new DragDropEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new TimingDiagramDragDropEditPolicy());
        this.installEditPolicy("AppliedStereotypeLabelDisplayEditPolicy", (EditPolicy)new AppliedStereotypeNodeLabelDisplayEditPolicy());
        this.installEditPolicy("CreationPolicy", (EditPolicy)new CustomInteractionCreationEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                View childView = (View)child.getModel();
                switch (UMLVisualIDRegistry.getVisualID(childView)) {
                    case 69: {
                        return new BorderItemResizableEditPolicy();
                    }
                }
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected void handleNotificationEvent(Notification event) {
        super.handleNotificationEvent(event);
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new CustomInteractionRectangleFigure();
        return this.primaryShape;
    }

    public CustomInteractionRectangleFigure getPrimaryShape() {
        return (CustomInteractionRectangleFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof InteractionNameEditPart) {
            ((InteractionNameEditPart)childEditPart).setLabel((IFigure)this.getPrimaryShape().getHeaderLabel());
            return true;
        }
        if (childEditPart instanceof InteractionCompartmentEditPartTN) {
            RectangleFigure pane = this.getPrimaryShape().getCompartmentFigure();
            this.setupContentPane((IFigure)pane);
            pane.add(((InteractionCompartmentEditPartTN)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof TimeRulerCompartmentEditPartCN) {
            RectangleFigure pane = this.getPrimaryShape().getTimeRulerContainerFigure();
            this.setupContentPane((IFigure)pane);
            pane.add(((TimeRulerCompartmentEditPartCN)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof GateEditPart) {
            BorderItemLocator locator = new BorderItemLocator(this.getMainFigure(), 0);
            this.getBorderedFigure().getBorderItemContainer().add(((GateEditPart)childEditPart).getFigure(), (Object)locator);
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof InteractionNameEditPart) {
            return true;
        }
        if (childEditPart instanceof InteractionCompartmentEditPartTN) {
            RectangleFigure pane = this.getPrimaryShape().getCompartmentFigure();
            pane.remove(((InteractionCompartmentEditPartTN)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof TimeRulerCompartmentEditPartCN) {
            RectangleFigure pane = this.getPrimaryShape().getTimeRulerContainerFigure();
            pane.remove(((TimeRulerCompartmentEditPartCN)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof GateEditPart) {
            this.getBorderedFigure().getBorderItemContainer().remove(((GateEditPart)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        if (editPart instanceof InteractionCompartmentEditPartTN) {
            return this.getPrimaryShape().getCompartmentFigure();
        }
        if (editPart instanceof TimeRulerCompartmentEditPartCN) {
            return this.getPrimaryShape().getTimeRulerContainerFigure();
        }
        if (editPart instanceof IBorderItemEditPart) {
            return this.getBorderedFigure().getBorderItemContainer();
        }
        return this.getContentPane();
    }

    protected NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(600, 400);
        return result;
    }

    protected NodeFigure createMainFigure() {
        return new SelectableBorderedNodeFigure((IFigure)this.createMainFigureWithSVG());
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(5);
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    protected void setLineWidth(int width) {
        super.setLineWidth(width);
    }

    protected void setLineType(int style) {
        if (this.primaryShape instanceof IPapyrusNodeFigure) {
            ((IPapyrusNodeFigure)this.primaryShape).setLineStyle(style);
        }
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(37));
    }

    public EditPart getTargetEditPart(Request request) {
        if (request instanceof CreateViewAndElementRequest) {
            CreateElementRequestAdapter adapter = ((CreateViewAndElementRequest)request).getViewAndElementDescriptor().getCreateElementRequestAdapter();
            IElementType type = (IElementType)adapter.getAdapter(IElementType.class);
            if (type == UMLElementTypes.Lifeline_19) {
                return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(5));
            }
            if (type == UMLElementTypes.Lifeline_20) {
                return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(5));
            }
            if (type == UMLElementTypes.Node_24) {
                return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(29));
            }
            if (type == UMLElementTypes.Node_25) {
                return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(29));
            }
        }
        return super.getTargetEditPart(request);
    }
}

