/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.pages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.uml.diagram.wizards.CreateModelWizard;
import org.eclipse.papyrus.uml.diagram.wizards.Messages;
import org.eclipse.papyrus.uml.diagram.wizards.SettingsHelper;
import org.eclipse.papyrus.uml.diagram.wizards.category.DiagramCategoryDescriptor;
import org.eclipse.papyrus.uml.diagram.wizards.category.DiagramCategoryRegistry;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectDiagramCategoryPage
extends WizardPage {
    private final List<Button> myDiagramKindButtons = new ArrayList<Button>();
    private final List<String> mySelectedDiagramCategoryIds = new LinkedList<String>();
    public static final String PAGE_ID = "SelectDiagramCategory";
    public static final String DEFAULT_EXTENSION = "uml";
    private final boolean myAllowSeveralCategories;

    public SelectDiagramCategoryPage() {
        this(false);
    }

    public SelectDiagramCategoryPage(boolean allowSeveralCategories) {
        super(PAGE_ID);
        this.myAllowSeveralCategories = allowSeveralCategories;
        this.setTitle(Messages.SelectDiagramCategoryPage_select_language);
    }

    public void setWizard(IWizard newWizard) {
        super.setWizard(newWizard);
        SettingsHelper settingsHelper = new SettingsHelper(this.getDialogSettings());
        String[] defaultDiagramCategory = settingsHelper.getDefaultDiagramCategories();
        if (defaultDiagramCategory != null && defaultDiagramCategory.length > 0) {
            if (this.myAllowSeveralCategories) {
                this.setDefaultDiagramCategories(defaultDiagramCategory);
            } else {
                this.setDefaultDiagramCategories(new String[]{defaultDiagramCategory[0]});
            }
        }
    }

    public void createControl(Composite parent) {
        Composite plate = new Composite(parent, 0);
        plate.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 10;
        plate.setLayout((Layout)gridLayout);
        this.setControl((Control)plate);
        this.createDiagramCategoryForm(plate);
        this.setPageComplete(this.validatePage());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.setPageComplete(this.validatePage());
    }

    @Deprecated
    public String getDiagramCategory() {
        if (!this.mySelectedDiagramCategoryIds.isEmpty()) {
            return this.mySelectedDiagramCategoryIds.get(0);
        }
        return null;
    }

    public String[] getDiagramCategories() {
        return this.mySelectedDiagramCategoryIds.toArray(new String[this.mySelectedDiagramCategoryIds.size()]);
    }

    protected final void setDefaultDiagramCategories(String[] categories) {
        this.mySelectedDiagramCategoryIds.clear();
        this.mySelectedDiagramCategoryIds.addAll(Arrays.asList(categories));
    }

    protected boolean validatePage() {
        this.setMessage(null);
        this.setErrorMessage(null);
        String[] categories = this.getDiagramCategories();
        if (categories == null || categories.length == 0) {
            this.setErrorMessage(Messages.SelectDiagramCategoryPage_select_one_category);
            return false;
        }
        String[] stringArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            String newCategory = stringArray[n2];
            if (!this.validateCategoryExists(newCategory)) {
                return false;
            }
            ++n2;
        }
        return this.validateFileExtension(categories);
    }

    protected boolean validateFileExtension(String ... categories) {
        IStatus status = ((CreateModelWizard)this.getWizard()).diagramCategoryChanged(categories);
        switch (status.getSeverity()) {
            case 4: {
                this.setErrorMessage(status.getMessage());
                return false;
            }
            case 2: {
                this.setMessage(status.getMessage(), 2);
                break;
            }
            case 1: {
                this.setMessage(status.getMessage(), 1);
            }
        }
        return true;
    }

    protected boolean validateCategoryExists(String newCategory) {
        DiagramCategoryDescriptor selected = this.getDiagramCategoryMap().get(newCategory);
        if (selected == null) {
            this.setErrorMessage(NLS.bind((String)Messages.SelectDiagramCategoryPage_cannot_find_category, (Object)newCategory));
            return false;
        }
        return true;
    }

    protected Map<String, DiagramCategoryDescriptor> getDiagramCategoryMap() {
        return DiagramCategoryRegistry.getInstance().getDiagramCategoryMap();
    }

    private void createDiagramCategoryForm(Composite composite) {
        Group group = SelectDiagramCategoryPage.createGroup(composite, Messages.SelectDiagramCategoryPage_diagram_language_group);
        SelectionListener listener = new SelectionListener(){
            private SelectionEvent prevEvent;

            public void widgetSelected(SelectionEvent e) {
                if (e == this.prevEvent) {
                    return;
                }
                Button selected = (Button)e.widget;
                SelectDiagramCategoryPage.this.diagramCategorySelected((String)selected.getData(), selected.getSelection());
                SelectDiagramCategoryPage.this.setPageComplete(SelectDiagramCategoryPage.this.validatePage());
                this.prevEvent = e;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        for (DiagramCategoryDescriptor diagramCategoryDescriptor : this.getDiagramCategoryMap().values()) {
            Button button = this.createCategoryButton(diagramCategoryDescriptor, group);
            button.addSelectionListener(listener);
            this.myDiagramKindButtons.add(button);
        }
        this.checkDiagramCategoryButtons();
    }

    protected void diagramCategorySelected(String category, boolean checked) {
        if (checked) {
            if (!this.mySelectedDiagramCategoryIds.contains(category)) {
                this.mySelectedDiagramCategoryIds.add(category);
            }
        } else {
            this.mySelectedDiagramCategoryIds.remove(category);
        }
    }

    protected void checkDiagramCategoryButtons() {
        this.checkButtonsFor(this.mySelectedDiagramCategoryIds.toArray(new String[this.mySelectedDiagramCategoryIds.size()]));
    }

    protected void checkButtonsFor(String ... diagramCategories) {
        for (Button button : this.myDiagramKindButtons) {
            button.setSelection(false);
        }
        for (Button button : this.myDiagramKindButtons) {
            String[] stringArray = diagramCategories;
            int n = diagramCategories.length;
            int n2 = 0;
            while (n2 < n) {
                String diagramCategory = stringArray[n2];
                if (diagramCategory.equals(button.getData())) {
                    button.setSelection(true);
                }
                ++n2;
            }
        }
    }

    private Button createCategoryButton(DiagramCategoryDescriptor diagramCategoryDescriptor, Group group) {
        Button button = new Button((Composite)group, this.myAllowSeveralCategories ? 32 : 16);
        button.setText(diagramCategoryDescriptor.getLabel());
        button.setData((Object)diagramCategoryDescriptor.getId());
        Image image = SelectDiagramCategoryPage.getImage(diagramCategoryDescriptor.getIcon());
        if (image != null) {
            button.setImage(image);
        }
        button.setToolTipText(diagramCategoryDescriptor.getDescription());
        return button;
    }

    private static Image getImage(ImageDescriptor imageDescriptor) {
        if (imageDescriptor != null) {
            return new Image(null, imageDescriptor.getImageData());
        }
        return null;
    }

    private static Group createGroup(Composite parent, String name) {
        Group group = new Group(parent, 0);
        group.setText(name);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        group.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        group.setLayoutData((Object)data);
        return group;
    }
}

