/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.template;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.DiModelUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.uml.diagram.wizards.utils.WizardsHelper;
import org.eclipse.papyrus.uml.tools.model.UmlUtils;

public class InitFromTemplateCommand
extends RecordingCommand {
    private ModelSet modelSet;
    private final Resource myModelUMLResource;
    private final Resource myModelDiResource;
    private final Resource myModelNotationResource;
    private final String myUmlTemplatePath;
    private final String myDiTemplatePath;
    private final String myNotationTemplatePath;
    private final String myPluginId;

    public InitFromTemplateCommand(TransactionalEditingDomain editingDomain, ModelSet modelSet, String pluginId, String umlTemplatePath, String notationTemplatePath, String diTemplatePath) {
        super(editingDomain);
        this.modelSet = modelSet;
        this.myModelUMLResource = UmlUtils.getUmlResource((ModelSet)modelSet);
        this.myModelDiResource = DiModelUtils.getDiResource((ModelSet)modelSet);
        this.myModelNotationResource = NotationUtils.getNotationResource((ModelSet)modelSet);
        this.myPluginId = pluginId;
        this.myUmlTemplatePath = umlTemplatePath;
        this.myDiTemplatePath = diTemplatePath;
        this.myNotationTemplatePath = notationTemplatePath;
    }

    protected void doExecute() {
        try {
            this.initializeFromTemplate();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initializeFromTemplate() throws IOException {
        Resource templateDiResource = null;
        Resource templateNotationResource = null;
        Resource templateUmlResource = null;
        try {
            templateUmlResource = this.loadTemplateResource(this.myUmlTemplatePath);
            EcoreUtil.resolveAll((Resource)templateUmlResource);
            if (this.myDiTemplatePath != null && this.myNotationTemplatePath != null) {
                String diFileName = WizardsHelper.getFileNameWithoutExtension(this.myDiTemplatePath);
                String umlFileName = WizardsHelper.getFileNameWithoutExtension(this.myUmlTemplatePath);
                String notationFileName = WizardsHelper.getFileNameWithoutExtension(this.myNotationTemplatePath);
                if (diFileName.contentEquals(umlFileName) && diFileName.contentEquals(notationFileName)) {
                    if (this.myDiTemplatePath != null) {
                        templateDiResource = this.loadTemplateResource(this.myDiTemplatePath);
                        EcoreUtil.resolveAll((Resource)templateDiResource);
                    }
                    if (this.myNotationTemplatePath != null) {
                        templateNotationResource = this.loadTemplateResource(this.myNotationTemplatePath);
                        EcoreUtil.resolveAll((Resource)templateNotationResource);
                    }
                }
            }
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            Collection umlObjects = copier.copyAll((Collection)templateUmlResource.getContents());
            Collection diObjects = templateDiResource == null ? null : copier.copyAll((Collection)templateDiResource.getContents());
            Collection notationObjects = templateNotationResource == null ? null : copier.copyAll((Collection)templateNotationResource.getContents());
            copier.copyReferences();
            this.myModelUMLResource.getContents().addAll(umlObjects);
            if (diObjects != null) {
                this.myModelDiResource.getContents().addAll(diObjects);
            }
            if (notationObjects != null) {
                this.myModelNotationResource.getContents().addAll(notationObjects);
            }
        }
        catch (Throwable throwable) {
            if (templateUmlResource != null) {
                this.unload(templateUmlResource);
            }
            if (templateNotationResource != null) {
                this.unload(templateNotationResource);
            }
            if (templateDiResource != null) {
                this.unload(templateDiResource);
            }
            throw throwable;
        }
        if (templateUmlResource != null) {
            this.unload(templateUmlResource);
        }
        if (templateNotationResource != null) {
            this.unload(templateNotationResource);
        }
        if (templateDiResource != null) {
            this.unload(templateDiResource);
        }
    }

    private Resource loadTemplateResource(String path) {
        URL templateURL = Platform.getBundle((String)this.myPluginId).getResource(path);
        String fullUri = templateURL.getPath();
        URI uri = URI.createPlatformPluginURI((String)(String.valueOf(this.myPluginId) + fullUri), (boolean)true);
        Resource resource = this.modelSet.getResource(uri, true);
        if (resource.isLoaded()) {
            return resource;
        }
        return null;
    }

    private void unload(Resource resource) {
        resource.unload();
        resource.eAdapters().clear();
        this.modelSet.getResources().remove((Object)resource);
    }
}

