/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.template;

import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.papyrus.uml.diagram.wizards.template.ModelTemplateDescription;
import org.eclipse.papyrus.uml.diagram.wizards.template.ModelTemplatesContentProvider;
import org.eclipse.papyrus.uml.diagram.wizards.template.ModelTemplatesLabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class SelectModelTemplateComposite
extends Composite {
    private CheckboxTableViewer templateTableViewer;

    public SelectModelTemplateComposite(Composite parent) {
        super(parent, 0);
        this.setLayoutData(new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.createTemplatesViewer(this);
    }

    public void disable() {
        this.templateTableViewer.getTable().setEnabled(false);
    }

    private void createTemplatesViewer(Composite composite) {
        GridData data = new GridData(4, 4, true, false);
        this.templateTableViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)262144);
        this.templateTableViewer.getTable().setBackground(composite.getBackground());
        this.templateTableViewer.getTable().setLayoutData((Object)data);
        this.templateTableViewer.getTable().setEnabled(true);
        this.templateTableViewer.setContentProvider((IContentProvider)new ModelTemplatesContentProvider());
        this.templateTableViewer.setLabelProvider((IBaseLabelProvider)new ModelTemplatesLabelProvider());
        this.templateTableViewer.getControl().setEnabled(true);
        this.templateTableViewer.getTable().setLayout((Layout)new GridLayout());
    }

    public String getTemplatePath() {
        Object[] selected = this.templateTableViewer.getCheckedElements();
        if (selected.length > 0) {
            return ((ModelTemplateDescription)selected[0]).getUml_path();
        }
        return null;
    }

    public String getDiTemplatePath() {
        Object[] selected = this.templateTableViewer.getCheckedElements();
        if (selected.length > 0) {
            return ((ModelTemplateDescription)selected[0]).getDi_path();
        }
        return null;
    }

    public String getNotationTemplatePath() {
        Object[] selected = this.templateTableViewer.getCheckedElements();
        if (selected.length > 0) {
            return ((ModelTemplateDescription)selected[0]).getNotation_path();
        }
        return null;
    }

    public String getTemplatePluginId() {
        Object[] selected = this.templateTableViewer.getCheckedElements();
        if (selected.length > 0) {
            return ((ModelTemplateDescription)selected[0]).getPluginId();
        }
        return null;
    }

    public void selectElement(Object toSelect) {
        this.templateTableViewer.setCheckedElements(new Object[]{toSelect});
    }

    public ModelTemplatesContentProvider getContentProvider() {
        return (ModelTemplatesContentProvider)this.templateTableViewer.getContentProvider();
    }

    public void setInput(Object input) {
        this.templateTableViewer.setInput(input);
    }
}

