/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.dataprovider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.nebula.widgets.nattable.edit.editor.IComboBoxDataProvider;
import org.eclipse.papyrus.infra.nattable.manager.table.ITableAxisElementProvider;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.uml.nattable.utils.UMLTableUtils;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class UMLStereotypeSingleEnumerationComboBoxDataProvider
implements IComboBoxDataProvider {
    private ITableAxisElementProvider elementProvider;
    private Object axisElement;

    public UMLStereotypeSingleEnumerationComboBoxDataProvider(Object axisElement, ITableAxisElementProvider elementProvider) {
        this.axisElement = axisElement;
        this.elementProvider = elementProvider;
    }

    public List<?> getValues(int columnIndex, int rowIndex) {
        ArrayList<Enumerator> literals = new ArrayList<Enumerator>();
        Object el = this.elementProvider.getColumnElement(columnIndex);
        Object rowElement = this.elementProvider.getRowElement(rowIndex);
        el = AxisUtils.getRepresentedElement((Object)el);
        rowElement = AxisUtils.getRepresentedElement((Object)rowElement);
        Element modelElement = null;
        if (rowElement instanceof Element && el.equals(AxisUtils.getRepresentedElement((Object)this.axisElement))) {
            modelElement = (Element)rowElement;
        } else if (rowElement.equals(AxisUtils.getRepresentedElement((Object)this.axisElement)) && el instanceof Element) {
            modelElement = (Element)el;
        }
        if (modelElement != null) {
            EStructuralFeature feature;
            Stereotype current;
            EClass stereotypeDefinition;
            String id = AxisUtils.getPropertyId((Object)this.axisElement);
            Property property = UMLTableUtils.getRealStereotypeProperty((EObject)modelElement, id);
            List<Stereotype> ste = UMLTableUtils.getApplicableStereotypesWithThisProperty(modelElement, id);
            if (ste.size() == 1 && (stereotypeDefinition = (EClass)(current = ste.get(0)).getProfile().getDefinition((NamedElement)current)) != null && (feature = stereotypeDefinition.getEStructuralFeature(property.getName())) != null) {
                EEnum eenum = null;
                if (feature != null && feature.getEType() instanceof EEnum) {
                    eenum = (EEnum)feature.getEType();
                }
                if (eenum != null) {
                    for (EEnumLiteral literal : eenum.getELiterals()) {
                        Enumerator value = literal.getInstance();
                        literals.add(value);
                    }
                }
            }
        }
        return literals;
    }
}

