/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.nattable.paste.StereotypeApplicationStructure;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class UMLTableUtils {
    public static final String PROPERTY_OF_STEREOTYPE_PREFIX = "property_of_stereotype:/";

    private UMLTableUtils() {
    }

    public static Property getRealStereotypeProperty(EObject eobject, String id) {
        Element element;
        assert (id.startsWith(PROPERTY_OF_STEREOTYPE_PREFIX));
        if (eobject instanceof Element && (element = (Element)eobject).getNearestPackage() != null) {
            String propertyQN = id.replace(PROPERTY_OF_STEREOTYPE_PREFIX, "");
            String propertyName = NamedElementUtil.getNameFromQualifiedName((String)propertyQN);
            String stereotypeQN = NamedElementUtil.getParentQualifiedName((String)propertyQN);
            String stereotypeName = NamedElementUtil.getNameFromQualifiedName((String)stereotypeQN);
            String profileQN = NamedElementUtil.getParentQualifiedName((String)stereotypeQN);
            Profile profile = element.getNearestPackage().getAppliedProfile(profileQN, true);
            if (profile != null) {
                Stereotype ste = profile.getOwnedStereotype(stereotypeName);
                return (Property)ste.getMember(propertyName);
            }
        }
        return null;
    }

    public static Property getRealStereotypeProperty(EObject eobject, String id, Map<?, ?> sharedMap) {
        assert (id.startsWith(PROPERTY_OF_STEREOTYPE_PREFIX));
        if (eobject instanceof Element) {
            Profile profile;
            Package nearestPackage;
            Element element = (Element)eobject;
            String propertyQN = id.replace(PROPERTY_OF_STEREOTYPE_PREFIX, "");
            String propertyName = NamedElementUtil.getNameFromQualifiedName((String)propertyQN);
            String stereotypeQN = NamedElementUtil.getParentQualifiedName((String)propertyQN);
            String stereotypeName = NamedElementUtil.getNameFromQualifiedName((String)stereotypeQN);
            String profileQN = NamedElementUtil.getParentQualifiedName((String)stereotypeQN);
            if (sharedMap != null) {
                Element context = (Element)sharedMap.get("pastedElementContainer");
                nearestPackage = context.getNearestPackage();
            } else {
                nearestPackage = element.getNearestPackage();
            }
            if (nearestPackage != null && (profile = nearestPackage.getAppliedProfile(profileQN, true)) != null) {
                Stereotype ste = profile.getOwnedStereotype(stereotypeName);
                return (Property)ste.getMember(propertyName);
            }
        }
        return null;
    }

    public static final List<Stereotype> getAppliedStereotypesWithThisProperty(Element element, String id) {
        Property prop;
        assert (id.startsWith(PROPERTY_OF_STEREOTYPE_PREFIX));
        ArrayList<Stereotype> stereotypes = new ArrayList<Stereotype>();
        if (element.eResource() != null && (prop = UMLTableUtils.getRealStereotypeProperty((EObject)element, id)) instanceof Property) {
            for (Stereotype current : element.getAppliedStereotypes()) {
                if (!current.getAllAttributes().contains((Object)prop)) continue;
                stereotypes.add(current);
            }
        }
        return stereotypes;
    }

    public static final List<Stereotype> getApplicableStereotypesWithThisProperty(Element element, String id) {
        Property prop;
        assert (id.startsWith(PROPERTY_OF_STEREOTYPE_PREFIX));
        ArrayList<Stereotype> stereotypes = new ArrayList<Stereotype>();
        if (element.eResource() != null && (prop = UMLTableUtils.getRealStereotypeProperty((EObject)element, id)) instanceof Property) {
            for (Stereotype current : element.getApplicableStereotypes()) {
                if (!current.getAllAttributes().contains((Object)prop)) continue;
                stereotypes.add(current);
            }
        }
        return stereotypes;
    }

    public static final List<Stereotype> getAppliedStereotypesWithThisProperty(Element element, String id, Map<?, ?> sharedMap) {
        Property prop;
        List<StereotypeApplicationStructure> struct;
        assert (id.startsWith(PROPERTY_OF_STEREOTYPE_PREFIX));
        ArrayList<Stereotype> stereotypes = new ArrayList<Stereotype>();
        if (sharedMap != null && (struct = UMLTableUtils.findStereotypeApplicationDataStructure(element, id, sharedMap)) != null) {
            for (StereotypeApplicationStructure current : struct) {
                stereotypes.add(current.getStereotype());
            }
        }
        if (element.eResource() != null && (prop = UMLTableUtils.getRealStereotypeProperty((EObject)element, id, sharedMap)) instanceof Property) {
            for (StereotypeApplicationStructure current : element.getAppliedStereotypes()) {
                if (!current.getAllAttributes().contains((Object)prop)) continue;
                stereotypes.add((Stereotype)current);
            }
        }
        return stereotypes;
    }

    public static final List<StereotypeApplicationStructure> findStereotypeApplicationDataStructure(Element editedElement, String id, Map<?, ?> sharedMap) {
        List list = (List)sharedMap.get(editedElement);
        if (list != null && !list.isEmpty()) {
            String propertyQN = id.replace(PROPERTY_OF_STEREOTYPE_PREFIX, "");
            for (StereotypeApplicationStructure current : list) {
                if (!current.getProperty().getQualifiedName().equals(propertyQN)) continue;
                return Collections.singletonList(current);
            }
        }
        return null;
    }
}

