/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.navigation.contributor;

import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.services.navigation.service.NavigableElement;
import org.eclipse.papyrus.infra.widgets.util.IRevealSemanticElement;
import org.eclipse.papyrus.infra.widgets.util.NavigationTarget;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Behavior;

public class CBANavigableElement
implements NavigableElement {
    protected final Behavior behavior;

    public CBANavigableElement(Behavior behavior) {
        this.behavior = behavior;
    }

    public String getLabel() {
        String label = "Go to behavior" + this.getCBALabel();
        return label;
    }

    public String getDescription() {
        return "Go to the Behavior linked with to this CallBehaviorAction" + this.getCBALabel();
    }

    protected String getCBALabel() {
        if (this.behavior == null) {
            return " (Undefined)";
        }
        return " (" + this.behavior.getName() + ")";
    }

    @Deprecated
    public void navigate(IRevealSemanticElement navigationContext) {
        if (!this.isEnabled()) {
            return;
        }
        navigationContext.revealSemanticElement(Collections.singletonList(this.behavior));
    }

    public Image getImage() {
        if (this.behavior == null) {
            return null;
        }
        try {
            return ((LabelProviderService)ServiceUtilsForEObject.getInstance().getServiceRegistry((EObject)this.behavior).getService(LabelProviderService.class)).getLabelProvider().getImage((Object)this.behavior);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean isEnabled() {
        return this.behavior != null;
    }

    public boolean navigate(NavigationTarget navigationContext) {
        if (!this.isEnabled()) {
            return false;
        }
        return navigationContext.revealElement((Object)this.behavior);
    }
}

