/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.widgets;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.emf.providers.EMFGraphicalContentProvider;
import org.eclipse.papyrus.infra.emf.providers.EMFLabelProvider;
import org.eclipse.papyrus.infra.emf.utils.HistoryUtil;
import org.eclipse.papyrus.infra.emf.utils.ProviderHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.properties.Activator;
import org.eclipse.papyrus.uml.properties.creation.UMLPropertyEditorFactory;
import org.eclipse.papyrus.uml.properties.widgets.EStructuralFeatureEditor;
import org.eclipse.papyrus.uml.tools.providers.UMLContainerContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLFilteredLabelProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.papyrus.views.properties.providers.CreateInFeatureContentProvider;
import org.eclipse.papyrus.views.properties.providers.FeatureContentProvider;
import org.eclipse.papyrus.views.properties.widgets.layout.PropertiesLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class EObjectContentsEditor
extends Composite {
    protected Composite contents;
    protected Composite buttonsBar;
    protected EReference reference;
    protected IObservableValue modelElementObservable;
    protected Button addButton;
    protected Button deleteButton;
    protected IChangeListener valueListener;
    protected Composite self;

    public EObjectContentsEditor(Composite parent, int style, EReference reference) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.self = new Group((Composite)this, 0);
        ((Group)this.self).setText(String.valueOf(reference.getName()) + ": " + reference.getEType().getName());
        this.self.setLayout((Layout)new PropertiesLayout());
        this.buttonsBar = new Composite(this.self, 0);
        this.buttonsBar.setLayout((Layout)new FillLayout());
        this.buttonsBar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.createAddButton();
        this.createDeleteButton();
        this.updateButtonsBar();
        this.contents = new Composite(this.self, 0);
        this.contents.setLayout((Layout)new PropertiesLayout());
        this.contents.setLayoutData((Object)new GridData(4, 4, true, true));
        this.reference = reference;
        this.valueListener = new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                EObjectContentsEditor.this.updateContents();
            }
        };
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                EObjectContentsEditor.this.dispose();
            }
        });
    }

    public void setValue(IObservableValue observable) {
        if (this.modelElementObservable != null) {
            this.modelElementObservable.removeChangeListener(this.valueListener);
        }
        this.modelElementObservable = observable;
        this.modelElementObservable.addChangeListener(this.valueListener);
        this.updateContents();
    }

    public void dispose() {
        if (this.modelElementObservable != null) {
            this.modelElementObservable.removeChangeListener(this.valueListener);
        }
    }

    protected void updateContents() {
        EObject dataTypeInstance = (EObject)this.modelElementObservable.getValue();
        Control[] controlArray = this.contents.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        if (dataTypeInstance != null) {
            ILabelProvider labelProvider;
            EClass dataTypeDefinition = dataTypeInstance.eClass();
            try {
                labelProvider = ((LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)dataTypeInstance)).getLabelProvider();
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
                labelProvider = new UMLLabelProvider();
            }
            for (EStructuralFeature feature : dataTypeDefinition.getEAllStructuralFeatures()) {
                EStructuralFeatureEditor propertyEditor = new EStructuralFeatureEditor(this.contents, 0);
                propertyEditor.setProviders((IStaticContentProvider)new UMLContentProvider(dataTypeInstance, feature), labelProvider);
                if (feature instanceof EReference) {
                    propertyEditor.setValueFactory((ReferenceValueFactory)this.getUMLPropertyEditorFactory(dataTypeInstance, (EReference)feature));
                }
                propertyEditor.setFeatureToEdit(feature.getName(), feature, dataTypeInstance);
            }
        }
        this.updateButtonsBar();
        this.layout();
    }

    public void layout() {
        this.contents.layout();
        this.self.layout();
        super.layout();
        this.getParent().layout();
    }

    protected void createAddButton() {
        this.addButton = new Button(this.buttonsBar, 8);
        this.addButton.setImage(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("icons/Add_12x12.gif"));
        this.addButton.setToolTipText("Create element");
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EObjectContentsEditor.this.addAction();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void addAction() {
        EClassifier classifier = this.reference.getEType();
        if (classifier instanceof EClass) {
            EClass classToInstantiate = (EClass)classifier;
            classToInstantiate.isAbstract();
            EPackage ePackage = classToInstantiate.getEPackage();
            EObject value = ePackage.getEFactoryInstance().create(classToInstantiate);
            this.modelElementObservable.setValue((Object)value);
        }
    }

    protected void createDeleteButton() {
        this.deleteButton = new Button(this.buttonsBar, 8);
        this.deleteButton.setImage(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("icons/Delete_12x12.gif"));
        this.deleteButton.setToolTipText("Unset value");
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EObjectContentsEditor.this.deleteAction();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void deleteAction() {
        this.modelElementObservable.setValue(null);
    }

    protected void updateButtonsBar() {
        this.deleteButton.setEnabled(this.modelElementObservable != null && this.modelElementObservable.getValue() != null);
    }

    protected UMLPropertyEditorFactory getUMLPropertyEditorFactory(EObject dataTypeInstance, EReference reference) {
        UMLPropertyEditorFactory factory = new UMLPropertyEditorFactory(reference);
        EClass type = reference.getEReferenceType();
        factory.setContainerLabelProvider((ILabelProvider)new UMLFilteredLabelProvider());
        factory.setReferenceLabelProvider((ILabelProvider)new EMFLabelProvider());
        UMLContainerContentProvider contentProvider = new UMLContainerContentProvider(dataTypeInstance, reference);
        EMFGraphicalContentProvider provider = ProviderHelper.encapsulateProvider((ITreeContentProvider)contentProvider, (ResourceSet)dataTypeInstance.eResource().getResourceSet(), (String)HistoryUtil.getHistoryID((EObject)dataTypeInstance, (EStructuralFeature)reference, (String)"container"));
        factory.setContainerContentProvider((IStaticContentProvider)provider);
        factory.setReferenceContentProvider((CreateInFeatureContentProvider)new FeatureContentProvider(type));
        return factory;
    }
}

