/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.search.ui.providers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.uml.search.ui.pages.PapyrusSearchResultPage;
import org.eclipse.papyrus.uml.search.ui.query.AbstractPapyrusQuery;
import org.eclipse.papyrus.uml.search.ui.results.PapyrusSearchResult;
import org.eclipse.papyrus.views.search.results.AbstractResultEntry;
import org.eclipse.papyrus.views.search.results.ResultEntry;
import org.eclipse.papyrus.views.search.utils.MatchUtils;
import org.eclipse.search.ui.text.AbstractTextSearchResult;

public class ResultContentProvider
implements ITreeContentProvider {
    private final Object[] EMPTY_ARR = new Object[0];
    private AbstractTextSearchResult fResult = null;
    private PapyrusSearchResultPage fPage = null;
    private AbstractTreeViewer fViewer;
    private Map<Object, Set<Object>> fChildrenMap;

    public AbstractTreeViewer getfViewer() {
        return this.fViewer;
    }

    public void setfViewer(AbstractTreeViewer fViewer) {
        this.fViewer = fViewer;
    }

    public ResultContentProvider(PapyrusSearchResultPage page, AbstractTreeViewer viewer) {
        this.fPage = page;
        this.fViewer = viewer;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput != null) {
            if (newInput instanceof PapyrusSearchResult) {
                this.fResult = (AbstractTextSearchResult)newInput;
                this.initialize();
            }
        } else {
            this.fResult = AbstractPapyrusQuery.Empty.INSTANCE.getSearchResult();
        }
    }

    public Object[] getElements(Object inputElement) {
        Object[] children = this.getChildren(inputElement);
        int elementLimit = this.getElementLimit();
        if (elementLimit != -1 && elementLimit < children.length) {
            Object[] limitedChildren = new Object[elementLimit];
            System.arraycopy(children, 0, limitedChildren, 0, elementLimit);
            return limitedChildren;
        }
        return children;
    }

    private int getElementLimit() {
        return this.fPage.getElementLimit();
    }

    public void clear() {
        this.initialize();
        this.fViewer.refresh();
    }

    public void initialize() {
        this.fChildrenMap = new HashMap<Object, Set<Object>>();
        Set realMatches = MatchUtils.getMatches((AbstractTextSearchResult)this.fResult, (boolean)true);
        for (AbstractResultEntry resultEntry : realMatches) {
            this.insert(resultEntry, false);
        }
    }

    protected boolean insertChild(Object parent, Object child) {
        Set<Object> children = this.fChildrenMap.get(parent);
        if (children == null) {
            children = new HashSet<Object>();
            this.fChildrenMap.put(parent, children);
        }
        boolean found = false;
        for (Object childInMap : children) {
            if (!(child instanceof AbstractResultEntry) || !(childInMap instanceof AbstractResultEntry) || !((AbstractResultEntry)childInMap).equals(child)) continue;
            if (!(child instanceof ResultEntry) && childInMap instanceof ResultEntry) {
                this.replaceResultEntryByRealResult((AbstractResultEntry)childInMap, (AbstractResultEntry)child);
            }
            found = true;
            break;
        }
        if (!found) {
            children.add(child);
            return true;
        }
        return false;
    }

    protected void replaceResultEntryByRealResult(AbstractResultEntry toReplace, AbstractResultEntry replacement) {
        for (Object childInMap : this.fChildrenMap.get(toReplace)) {
            if (!(childInMap instanceof AbstractResultEntry)) continue;
            ((AbstractResultEntry)childInMap).setParent((Object)replacement);
        }
        this.fChildrenMap.put(replacement, this.fChildrenMap.get(toReplace));
        replacement.setParent(toReplace.getParent());
        this.fChildrenMap.remove(toReplace);
        for (Object key : this.fChildrenMap.keySet()) {
            if (!this.fChildrenMap.get(key).contains(toReplace)) continue;
            this.fChildrenMap.get(key).remove(toReplace);
            this.fChildrenMap.get(key).add(replacement);
        }
    }

    protected Object getUpdateParent(Object child) {
        Object parent = this.getParent(child);
        Object existingParent = null;
        block0: for (Object key : this.fChildrenMap.keySet()) {
            if (key instanceof AbstractResultEntry && ((AbstractResultEntry)key).equals(parent)) {
                existingParent = key;
                break;
            }
            for (Object childInMap : this.fChildrenMap.get(key)) {
                if (!(childInMap instanceof AbstractResultEntry) || !((AbstractResultEntry)childInMap).equals(parent)) continue;
                existingParent = childInMap;
                continue block0;
            }
        }
        if (existingParent != null) {
            ((AbstractResultEntry)child).setParent(existingParent);
            return existingParent;
        }
        return parent;
    }

    protected void insert(Object child, boolean refreshViewer) {
        Object parent = this.getUpdateParent(child);
        while (parent != null) {
            if (this.insertChild(parent, child)) {
                if (refreshViewer) {
                    this.fViewer.add(parent, child);
                }
            } else {
                if (refreshViewer) {
                    this.fViewer.refresh(parent);
                }
                return;
            }
            child = parent;
            parent = this.getUpdateParent(child);
        }
        if (this.insertChild(this.fResult, child) && refreshViewer) {
            this.fViewer.add((Object)this.fResult, child);
        }
    }

    protected boolean hasChild(Object parent, Object child) {
        Set<Object> children = this.fChildrenMap.get(parent);
        if (children != null) {
            for (Object childInMap : children) {
                if (!(childInMap instanceof AbstractResultEntry) || !(child instanceof AbstractResultEntry) || !((AbstractResultEntry)childInMap).equals(child)) continue;
                if (!(child instanceof ResultEntry) && childInMap instanceof ResultEntry) {
                    this.replaceResultEntryByRealResult((AbstractResultEntry)childInMap, (AbstractResultEntry)child);
                }
                return true;
            }
        }
        return false;
    }

    protected void removeFromSiblings(Object element, Object parent) {
        Set<Object> siblings = this.fChildrenMap.get(parent);
        if (siblings != null) {
            siblings.remove(element);
        }
    }

    public void remove(Object element, boolean refreshViewer) {
        if (this.hasChildren(element)) {
            if (refreshViewer) {
                this.fViewer.refresh(element);
            }
        } else {
            this.fChildrenMap.remove(element);
            Object parent = this.getUpdateParent(element);
            if (parent != null) {
                this.removeFromSiblings(element, parent);
                this.remove(parent, refreshViewer);
            } else {
                this.removeFromSiblings(element, this.fResult);
                if (refreshViewer) {
                    this.fViewer.refresh();
                }
            }
        }
    }

    public synchronized void elementsChanged(Object[] updatedElements) {
        int i = 0;
        while (i < updatedElements.length) {
            if (updatedElements[i] instanceof AbstractResultEntry) {
                AbstractResultEntry resultEntry = (AbstractResultEntry)updatedElements[i];
                Set matches = MatchUtils.getMatches((AbstractTextSearchResult)this.fResult, (boolean)true);
                if (matches.contains(updatedElements[i])) {
                    Object parent = this.getUpdateParent(resultEntry);
                    if (this.hasChild(parent, resultEntry)) {
                        this.fViewer.update(new Object[]{resultEntry, parent}, null);
                    } else {
                        this.insert(resultEntry, true);
                    }
                } else {
                    this.remove(resultEntry, true);
                }
            } else if (this.fResult.getMatchCount(updatedElements[i]) > 0) {
                this.insert(updatedElements[i], true);
            } else {
                this.remove(updatedElements[i], true);
            }
            ++i;
        }
    }

    public Object[] getChildren(Object parentElement) {
        Set<Object> children = this.fChildrenMap.get(parentElement);
        if (children == null) {
            return this.EMPTY_ARR;
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof AbstractResultEntry) {
            AbstractResultEntry match = (AbstractResultEntry)element;
            return match.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }
}

