/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.uml.service.types.command.NotContainmentMoveCommand;
import org.eclipse.papyrus.uml.service.types.helper.ActivityGroupHelper;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.InterruptibleActivityRegion;
import org.eclipse.uml2.uml.UMLPackage;

public class InterruptibleActivityRegionHelper
extends ActivityGroupHelper {
    protected ICommand getCreateCommand(CreateElementRequest req) {
        CreateElementRequest createRequest = this.isActivityNode(req.getElementType()) ? this.initCreateActivityNodeRequestInInterruptibleRegion(req) : req;
        return super.getCreateCommand(createRequest);
    }

    protected CreateElementRequest initCreateActivityNodeRequestInInterruptibleRegion(CreateElementRequest baseReq) {
        if (baseReq == null) {
            return null;
        }
        CreateElementRequest req = new CreateElementRequest(baseReq.getElementType());
        InterruptibleActivityRegion inrruptibleActivityRegion = (InterruptibleActivityRegion)baseReq.getContainer();
        req.setContainer((EObject)inrruptibleActivityRegion.getInActivity());
        req.setContainmentFeature(this.findActivityFeature(baseReq.getElementType().getEClass()));
        req.setParameter("IN_INTERRUPTIBLE_ACTIVITY_REGION", (Object)inrruptibleActivityRegion);
        return req;
    }

    protected EReference findActivityFeature(EClass eClass) {
        if (UMLPackage.eINSTANCE.getStructuredActivityNode().isSuperTypeOf(eClass)) {
            return UMLPackage.eINSTANCE.getActivity_StructuredNode();
        }
        return UMLPackage.eINSTANCE.getActivity_OwnedNode();
    }

    protected ICommand getMoveCommand(MoveRequest req) {
        if (req != null && this.isTargetContainerInterruptibleActivityRegioin(req)) {
            return this.createMoveCommandWithSetReference(req, UMLPackage.eINSTANCE.getInterruptibleActivityRegion_Node());
        }
        return super.getMoveCommand(req);
    }

    private boolean isTargetContainerInterruptibleActivityRegioin(MoveRequest req) {
        return req.getTargetContainer() instanceof InterruptibleActivityRegion;
    }

    protected ICommand createMoveCommandWithSetReference(MoveRequest req, EReference featureToSetReference) {
        EObject nonContainmentContainer = req.getTargetContainer();
        CompositeCommand result = new CompositeCommand("Move elements in non containment Activity container");
        NotContainmentMoveCommand moveCommand = new NotContainmentMoveCommand(this.createMoveToActivityRequest(req));
        result.add((IUndoableOperation)moveCommand);
        for (Object o : req.getElementsToMove().keySet()) {
            if (!(o instanceof ActivityNode)) continue;
            result.add((IUndoableOperation)new SetValueCommand(new SetRequest(nonContainmentContainer, (EStructuralFeature)featureToSetReference, o)));
        }
        return result;
    }

    protected MoveRequest createMoveToActivityRequest(MoveRequest baseReq) {
        if (baseReq == null) {
            return null;
        }
        MoveRequest result = new MoveRequest(baseReq.getEditingDomain(), (EObject)((InterruptibleActivityRegion)baseReq.getTargetContainer()).getInActivity(), baseReq.getElementsToMove());
        for (Object o : baseReq.getElementsToMove().keySet()) {
            if (!(o instanceof ActivityNode)) continue;
            ActivityNode node = (ActivityNode)o;
            result.setTargetFeature((EObject)node, this.findActivityFeature(node.eClass()));
        }
        return result;
    }
}

