/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper.advice;

import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.papyrus.uml.tools.model.UmlUtils;

public class ContainmentSubsetRemovalAdvice
extends AbstractEditHelperAdvice {
    private static final String EDIT_POLICY_COMMAND = "edit policy command";

    protected ICommand getAfterDestroyElementCommand(DestroyElementRequest request) {
        Collection supersets;
        Object result = super.getAfterDestroyElementCommand(request);
        if (request.getParameter(EDIT_POLICY_COMMAND) != null) {
            return result;
        }
        final EObject destructee = request.getElementToDestroy();
        EReference containment = destructee.eContainmentFeature();
        Collection collection = supersets = !UmlUtils.isSubset((EReference)containment) ? null : UmlUtils.getAllChangeableSupersets((EReference)containment);
        if (supersets != null) {
            final EObject container = destructee.eContainer();
            AbstractCommand advice = new AbstractCommand("Ensure supersets"){

                protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    for (EReference superset : supersets) {
                        this.remove(container, superset, destructee);
                    }
                    return CommandResult.newOKCommandResult();
                }

                private void remove(EObject owner, EReference reference, EObject object) {
                    if (reference.isMany()) {
                        ((Collection)owner.eGet((EStructuralFeature)reference)).remove(object);
                    } else if (owner.eGet((EStructuralFeature)reference) == object) {
                        owner.eUnset((EStructuralFeature)reference);
                    }
                }

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    return CommandResult.newOKCommandResult();
                }

                protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    return CommandResult.newOKCommandResult();
                }
            };
            result = result == null ? advice : result.compose((IUndoableOperation)advice);
        }
        return result;
    }
}

