/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.extendedtypes.invariantstereotypeconfiguration;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.extendedtypes.invariantsemantictypeconfiguration.IInvariantElementMatcher;
import org.eclipse.papyrus.uml.tools.extendedtypes.invariantstereotypeconfiguration.InvariantStereotypeConfiguration;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvariantStereotypeElementMatcher
implements IInvariantElementMatcher<InvariantStereotypeConfiguration> {
    private String stereotypeQualifiedName;
    private boolean isStrict;

    public boolean matches(EObject eObject) {
        if (!(eObject instanceof Element)) {
            return false;
        }
        String stereotypeQualifiedName = this.getStereotypeQualifiedName();
        if (stereotypeQualifiedName == null) {
            return false;
        }
        Stereotype appliedStereotype = ((Element)eObject).getAppliedStereotype(stereotypeQualifiedName);
        if (appliedStereotype != null) {
            return true;
        }
        if (!this.isStrict) {
            for (Stereotype stereotype : ((Element)eObject).getAppliedStereotypes()) {
                for (Stereotype superStereotype : StereotypeUtil.getAllSuperStereotypes((Stereotype)stereotype)) {
                    if (!stereotypeQualifiedName.equals(superStereotype.getQualifiedName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void init(InvariantStereotypeConfiguration ruleConfiguration) {
        this.setStereotypeQualifiedName(ruleConfiguration.getStereotypeQualifiedName());
        this.setStrict(ruleConfiguration.isStrict());
    }

    public String getStereotypeQualifiedName() {
        return this.stereotypeQualifiedName;
    }

    public void setStereotypeQualifiedName(String stereotypeQualifiedName) {
        this.stereotypeQualifiedName = stereotypeQualifiedName;
    }

    public boolean isStrict() {
        return this.isStrict;
    }

    public void setStrict(boolean isStrict) {
        this.isStrict = isStrict;
    }
}

