/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.adapters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerivedAttributeAdapter
extends AdapterImpl {
    private InternalEObject source;
    private EStructuralFeature derivedFeature;
    private List<EStructuralFeature> localFeatures = new ArrayList<EStructuralFeature>();
    private EStructuralFeature navigationFeature = null;
    private Adapter dependantAdapter = null;

    public DerivedAttributeAdapter(EObject source, EStructuralFeature derivedFeature, EStructuralFeature navigationFeature, EStructuralFeature dependantFeature, int eventType) {
        this(source, derivedFeature);
        this.addNavigatedDependency(navigationFeature, dependantFeature, eventType);
    }

    public DerivedAttributeAdapter(EObject source, EStructuralFeature derivedFeature, EStructuralFeature navigationFeature, Map<EStructuralFeature, Integer> dependentFeaturesMap) {
        this(source, derivedFeature);
        this.addNavigatedDependency(navigationFeature, dependentFeaturesMap);
    }

    public DerivedAttributeAdapter(EObject source, EStructuralFeature derivedFeature, EStructuralFeature localFeature) {
        this(source, derivedFeature);
        this.addLocalDependency(localFeature);
    }

    public DerivedAttributeAdapter(EObject source, EStructuralFeature derivedFeature) {
        this.source = (InternalEObject)source;
        this.derivedFeature = derivedFeature;
        source.eAdapters().add((Object)this);
    }

    public void addNavigatedDependency(EStructuralFeature navigationFeature, Map<EStructuralFeature, Integer> dependentFeaturesMap) {
        this.navigationFeature = navigationFeature;
        this.dependantAdapter = new DependentFeatureAdapter(dependentFeaturesMap);
    }

    public void addNavigatedDependency(EStructuralFeature navigationFeature, EStructuralFeature dependantFeature, int eventType) {
        this.navigationFeature = navigationFeature;
        this.dependantAdapter = new DependentFeatureAdapter(eventType, dependantFeature);
    }

    public void addLocalDependency(EStructuralFeature localFeature) {
        this.localFeatures.add(localFeature);
    }

    public void notifyChanged(Notification notification) {
        Object notificationFeature = notification.getFeature();
        if (notificationFeature != null && notificationFeature.equals(this.navigationFeature)) {
            switch (notification.getEventType()) {
                case 3: {
                    EObject added = (EObject)notification.getNewValue();
                    added.eAdapters().add((Object)this.dependantAdapter);
                    break;
                }
                case 1: {
                    EObject newValue = (EObject)notification.getNewValue();
                    EObject oldValue = (EObject)notification.getOldValue();
                    if (oldValue != null) {
                        oldValue.eAdapters().remove((Object)this.dependantAdapter);
                    }
                    if (newValue == null) break;
                    newValue.eAdapters().add((Object)this.dependantAdapter);
                    break;
                }
                case 4: {
                    EObject removed = (EObject)notification.getOldValue();
                    removed.eAdapters().remove((Object)this.dependantAdapter);
                    break;
                }
                default: {
                    return;
                }
            }
            this.notifyDerivedAttributeChange(notification);
        } else if (this.localFeatures.contains(notificationFeature)) {
            this.notifyDerivedAttributeChange(notification);
        }
    }

    protected void notifyDerivedAttributeChange(Notification msg) {
        if (this.source.eNotificationRequired()) {
            this.source.eNotify(this.getNotification());
        }
    }

    protected Notification getNotification() {
        return new ENotificationImpl(this.source, 1, this.derivedFeature, null, this.source.eGet(this.derivedFeature, true, true));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DependentFeatureAdapter
    extends AdapterImpl {
        private Map<EStructuralFeature, Integer> dependentFeaturesMap = new HashMap<EStructuralFeature, Integer>();

        public DependentFeatureAdapter(int eventType, EStructuralFeature feature) {
            this.dependentFeaturesMap.put(feature, eventType);
        }

        public DependentFeatureAdapter(Map<EStructuralFeature, Integer> dependentFeaturesMap) {
            this.dependentFeaturesMap.putAll(dependentFeaturesMap);
        }

        public void notifyChanged(Notification notification) {
            if (this.dependentFeaturesMap.containsKey(notification.getFeature()) && this.dependentFeaturesMap.get(notification.getFeature()).equals(notification.getEventType())) {
                DerivedAttributeAdapter.this.notifyDerivedAttributeChange(notification);
            }
        }
    }
}

