/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.commands;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.uml.tools.utils.CustomUMLUtil;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplyProfileCommand
extends RecordingCommand {
    private Package umlPackage;
    private Collection<Profile> profiles;
    private boolean saveProfileApplicationVersion;

    public ApplyProfileCommand(Package umlPackage, Collection<Profile> profiles, TransactionalEditingDomain editingDomain) {
        this(umlPackage, profiles, editingDomain, true);
    }

    public ApplyProfileCommand(Package umlPackage, Collection<Profile> profiles, TransactionalEditingDomain editingDomain, boolean saveProfileApplicationVersion) {
        super(editingDomain);
        this.umlPackage = umlPackage;
        this.profiles = profiles;
        this.saveProfileApplicationVersion = saveProfileApplicationVersion;
    }

    public ApplyProfileCommand(Package umlPackage, Profile profile, TransactionalEditingDomain editingDomain) {
        this(umlPackage, profile, editingDomain, true);
    }

    public ApplyProfileCommand(Package umlPackage, Profile profile, TransactionalEditingDomain editingDomain, boolean saveProfileApplicationVersion) {
        this(umlPackage, Collections.singletonList(profile), editingDomain, saveProfileApplicationVersion);
    }

    protected void doExecute() {
        for (Profile profile : this.profiles) {
            this.umlPackage.applyProfile(profile);
            if (!this.saveProfileApplicationVersion) continue;
            ProfileApplication profileApplication = this.umlPackage.getProfileApplication(profile);
            EAnnotation versionAnnotation = profile.getDefinition().getEAnnotation("PapyrusVersion");
            if (versionAnnotation == null) continue;
            int index = 0;
            EAnnotation existing = profileApplication.getEAnnotation("PapyrusVersion");
            while (existing != null) {
                index = profileApplication.getEAnnotations().indexOf((Object)existing);
                CustomUMLUtil.destroy((EObject)existing);
                existing = profileApplication.getEAnnotation("PapyrusVersion");
            }
            profileApplication.getEAnnotations().add(index, (Object)((EAnnotation)EcoreUtil.copy((EObject)versionAnnotation)));
        }
    }
}

