/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.model;

import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.infra.core.resource.EMFLogicalModel;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.util.UMLUtil;

public class UmlModel
extends EMFLogicalModel
implements IModel {
    public static final String UML_FILE_EXTENSION = "uml";
    public static final String MODEL_ID = "org.eclipse.papyrus.infra.core.resource.uml.UmlModel";

    public void createModel(IPath fullPath) {
        this.resourceURI = this.getPlatformURI(fullPath.addFileExtension(UML_FILE_EXTENSION));
        this.resource = this.getResourceSet().createResource(this.resourceURI, this.getContentType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ModelSet modelManager) {
        super.init(modelManager);
        Class<UMLUtil> clazz = UMLUtil.class;
        synchronized (UMLUtil.class) {
            UMLUtil.init((ResourceSet)modelManager);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected String getContentType() {
        return "org.eclipse.uml2.uml";
    }

    protected String getModelFileExtension() {
        return UML_FILE_EXTENSION;
    }

    public String getIdentifier() {
        return MODEL_ID;
    }

    public EObject lookupRoot() throws NotFoundException {
        if (this.resource == null || this.resource.getContents().isEmpty()) {
            throw new NotFoundException("No root defined in the model");
        }
        return (EObject)this.resource.getContents().get(0);
    }

    public void initializeEmptyModel() {
        if (!this.resource.getContents().isEmpty()) {
            return;
        }
        Model model = UMLFactory.eINSTANCE.createModel();
        model.setName("model");
        this.resource.getContents().add((Object)model);
    }

    public void unload() {
        for (Resource resource : this.resources) {
            if (resource == null) continue;
            CacheAdapter.getInstance().clear(resource);
        }
        super.unload();
    }
}

