/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.providers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.papyrus.emf.facet.util.emf.core.ModelUtils;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.tools.Activator;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Relationship;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.util.UMLSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingItemLabelProvider
implements IItemLabelProvider {
    public static final int SHOW_LABEL = 1;
    public static final int SHOW_METACLASS = 2;
    public static final int SHOW_STEREOTYPES = 4;
    private static String ST_LEFT = "\u00ab";
    private static String ST_RIGHT = "\u00bb";
    private static final Pattern UML2_LABEL_PATTERN = Pattern.compile("(?:<<(.+?)>>)?\\s*(<[^<>]+>)?\\s*(.*)");
    private final UMLSwitch<Boolean> showMetaclassSwitch = this.createShowMetaclassSwitch();
    private final AdapterFactory itemAdapterFactory;
    private final int style;

    public DelegatingItemLabelProvider(AdapterFactory itemAdapterFactory, int style) {
        this.itemAdapterFactory = itemAdapterFactory;
        this.style = style;
    }

    public DelegatingItemLabelProvider(AdapterFactory itemAdapterFactory) {
        this(itemAdapterFactory, 7);
    }

    public DelegatingItemLabelProvider(int style) {
        this(Activator.getDefault().getItemProviderAdapterFactory(), style);
    }

    public DelegatingItemLabelProvider() {
        this(Activator.getDefault().getItemProviderAdapterFactory());
    }

    public String getText(Object object) {
        Matcher m;
        String result;
        EObject element = EMFHelper.getEObject((Object)object);
        if (element == null) {
            return null;
        }
        IItemLabelProvider provider = this.getDelegate(element);
        String string = result = provider == null ? ModelUtils.getDefaultName((EObject)element) : provider.getText((Object)element);
        if (result != null && (m = UML2_LABEL_PATTERN.matcher(result)).matches()) {
            StringBuilder buf = new StringBuilder();
            String keywords = m.group(1);
            if (this.isShowStereotypes() && keywords != null) {
                buf.append(ST_LEFT).append(keywords).append(ST_RIGHT);
            }
            String label = m.group(3);
            if (this.isShowMetaclass() && (UML2Util.isEmpty((String)label) || this.shouldShowMetaclass(element))) {
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append(m.group(2));
            }
            if (this.isShowLabel() && !UML2Util.isEmpty((String)label)) {
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append(label);
            }
            result = buf.toString();
        }
        return result;
    }

    public Object getImage(Object object) {
        EObject element = EMFHelper.getEObject((Object)object);
        if (element == null) {
            return null;
        }
        IItemLabelProvider provider = this.getDelegate(element);
        return provider == null ? null : provider.getImage((Object)element);
    }

    public final boolean isShowLabel() {
        return (this.style & 1) == 1;
    }

    public final boolean isShowMetaclass() {
        return (this.style & 2) == 2;
    }

    public final boolean isShowStereotypes() {
        return (this.style & 4) == 4;
    }

    protected IItemLabelProvider getDelegate(EObject object) {
        return (IItemLabelProvider)this.itemAdapterFactory.adapt((Notifier)object, IItemLabelProvider.class);
    }

    protected boolean shouldShowMetaclass(EObject object) {
        return (Boolean)this.showMetaclassSwitch.doSwitch(object);
    }

    protected UMLSwitch<Boolean> createShowMetaclassSwitch() {
        return new UMLSwitch<Boolean>(){

            public Boolean defaultCase(EObject object) {
                return false;
            }

            public Boolean caseRelationship(Relationship object) {
                return true;
            }

            public Boolean caseAssociation(Association object) {
                return false;
            }

            public Boolean caseTemplateParameter(TemplateParameter object) {
                return true;
            }

            public Boolean caseTemplateSignature(TemplateSignature object) {
                return true;
            }
        };
    }
}

