/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.providers;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.tools.Activator;

public class EditServiceValidator {
    private EObject editedEObject;
    private EStructuralFeature editedFeature;
    private IElementEditService editingService;

    public EditServiceValidator(EObject editedEObject, EStructuralFeature editedFeature) {
        this.editedEObject = editedEObject;
        this.editedFeature = editedFeature;
        if (editedEObject != null) {
            this.editingService = ElementEditServiceUtils.getCommandProvider((Object)editedEObject);
        }
        if (this.editingService == null) {
            Activator.log.warn("Could not create service for " + EMFCoreUtil.getQualifiedName((EObject)editedEObject, (boolean)true));
        }
    }

    public boolean isValidValue(Object element) {
        EObject semanticElement = EMFHelper.getEObject((Object)element);
        if (semanticElement == null && element != null) {
            return false;
        }
        SetRequest req = new SetRequest(this.editedEObject, this.editedFeature, (Object)semanticElement);
        return this.editingService != null && this.editingService.canEdit((IEditCommandRequest)req);
    }
}

