/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.providers;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.papyrus.infra.emf.providers.strategy.ContainmentBrowseStrategy;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLContainmentBrowseStrategy
extends ContainmentBrowseStrategy {
    public UMLContainmentBrowseStrategy(ITreeContentProvider provider) {
        super(provider);
    }

    protected boolean browseElement(Object containerElement) {
        Object semanticElement = this.adaptableProvider.getAdaptedValue(containerElement);
        if (semanticElement == UMLPackage.eINSTANCE.getPackageImport_ImportedPackage()) {
            return true;
        }
        return super.browseElement(containerElement);
    }

    public TreePath findPath(Object semanticElement, Object[] rootElements) {
        EObject source = EMFHelper.getEObject((Object)semanticElement);
        if (source instanceof Element) {
            return super.findPath(semanticElement, rootElements);
        }
        Element baseElement = UMLUtil.getBaseElement((EObject)source);
        if (baseElement == null) {
            return super.findPath(semanticElement, rootElements);
        }
        return super.findPath((Object)baseElement, rootElements);
    }

    public void revealSemanticElement(List<?> elementsList) {
        LinkedList<Object> umlElementsList = new LinkedList<Object>();
        for (Object semanticElement : elementsList) {
            EObject source = EMFHelper.getEObject(semanticElement);
            Element baseElement = source instanceof Element ? (Element)source : UMLUtil.getBaseElement((EObject)source);
            if (baseElement == null) {
                umlElementsList.add(semanticElement);
                continue;
            }
            umlElementsList.add(baseElement);
        }
        super.revealSemanticElement(umlElementsList);
    }
}

