/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.util;

public class MultiplicityParser {
    public static String ANY = "0..*";
    public static String STAR = "*";
    public static String ONE = "1";
    public static String OPTIONAL = "0..1";
    public static String ONE_OR_MORE = "1..*";
    public static String SEPARATOR = "..";

    public static int[] getBounds(String value) {
        int upper;
        int lower;
        if (value == null) {
            return new int[]{1, 1};
        }
        if (!(value instanceof String)) {
            return null;
        }
        String multiplicityValue = value;
        if (!multiplicityValue.matches("([0-9]+\\.\\.)?([1-9][0-9]*|\\*)")) {
            return null;
        }
        if (multiplicityValue.equals(ANY) || multiplicityValue.equals(STAR)) {
            lower = 0;
            upper = -1;
        } else if (multiplicityValue.equals(OPTIONAL)) {
            lower = 0;
            upper = 1;
        } else if (multiplicityValue.equals(ONE_OR_MORE)) {
            lower = 1;
            upper = -1;
        } else if (multiplicityValue.equals(ONE)) {
            lower = 1;
            upper = 1;
        } else {
            try {
                if (multiplicityValue.contains(SEPARATOR)) {
                    lower = Integer.parseInt(multiplicityValue.substring(0, multiplicityValue.indexOf(SEPARATOR)));
                    String upperString = multiplicityValue.substring(multiplicityValue.indexOf(SEPARATOR) + SEPARATOR.length(), multiplicityValue.length());
                    upper = STAR.equals(upperString) ? -1 : Integer.parseInt(upperString);
                } else {
                    lower = upper = Integer.parseInt(multiplicityValue);
                }
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return new int[]{lower, upper};
    }

    public static String getMultiplicity(int lower, int upper) {
        if (lower == 0 && upper == -1) {
            return ANY;
        }
        if (lower == 0 && upper == 1) {
            return OPTIONAL;
        }
        if (lower == 1 && upper == -1) {
            return ONE_OR_MORE;
        }
        if (lower == 1 && upper == 1) {
            return ONE;
        }
        if (lower == upper) {
            return Integer.toString(lower);
        }
        return String.valueOf(lower) + SEPARATOR + (upper < 0 ? STAR : Integer.valueOf(upper));
    }

    public static boolean isValidMultiplicity(String value) {
        int[] lowerUpper = MultiplicityParser.getBounds(value);
        if (lowerUpper == null || lowerUpper.length < 2) {
            return false;
        }
        int lower = lowerUpper[0];
        int upper = lowerUpper[1];
        return MultiplicityParser.isValidMultiplicity(lower, upper);
    }

    public static boolean isValidMultiplicity(int lower, int upper) {
        if (lower < 0) {
            return false;
        }
        return (upper <= 0 || upper >= lower) && upper != 0;
    }
}

