/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.creation;

import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.views.properties.Activator;
import org.eclipse.papyrus.views.properties.contexts.Section;
import org.eclipse.papyrus.views.properties.contexts.Tab;
import org.eclipse.papyrus.views.properties.contexts.View;
import org.eclipse.papyrus.views.properties.messages.Messages;
import org.eclipse.papyrus.views.properties.runtime.DefaultDisplayEngine;
import org.eclipse.papyrus.views.properties.xwt.XWTSection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditionDialog
extends SelectionDialog {
    private Set<View> views;
    private Object input;
    private Set<XWTSection> sections = new HashSet<XWTSection>();
    private boolean cancelable = false;

    protected EditionDialog(Shell shell, boolean cancelable) {
        super(shell);
        this.cancelable = cancelable;
    }

    protected EditionDialog(Shell shell) {
        this(shell, false);
    }

    public void create() {
        super.create();
        if (this.getShell().getText() == null || "".equals(this.getShell().getText())) {
            this.setTitle(Messages.EditionDialog_CreateANewElement);
        }
        this.getShell().setImage(Activator.getDefault().getImage("org.eclipse.papyrus.infra.widgets", "/icons/papyrus.png"));
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                EditionDialog.this.dispose();
            }
        });
        this.display();
        this.getButton(1).setEnabled(this.cancelable);
    }

    public Composite getDialogArea() {
        return (Composite)super.getDialogArea();
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public void setViews(Set<View> views) {
        this.views = views;
    }

    private void display() {
        DefaultDisplayEngine display = new DefaultDisplayEngine();
        StructuredSelection selection = new StructuredSelection(this.input);
        Composite parent = new Composite(this.getDialogArea(), 0);
        parent.setLayout((Layout)new FillLayout());
        parent.setLayoutData((Object)new GridData(4, 1, true, false));
        this.getShell().setSize(600, 400);
        final LinkedHashSet<Tab> tabsList = new LinkedHashSet<Tab>();
        for (View view : this.views) {
            for (Section section : view.getSections()) {
                tabsList.add(section.getTab());
            }
        }
        LinkedList allTabs = new LinkedList(tabsList);
        Collections.sort(allTabs, new Comparator<Tab>(){

            @Override
            public int compare(Tab tab1, Tab tab2) {
                int priority2;
                int priority1 = this.getPriority(tab1);
                if (priority1 < (priority2 = this.getPriority(tab2))) {
                    return -1;
                }
                if (priority1 > priority2) {
                    return 1;
                }
                priority1 = this.getXWTTabPriority(tab1);
                if (priority1 < (priority2 = this.getXWTTabPriority(tab2))) {
                    return -1;
                }
                if (priority1 > priority2) {
                    return 1;
                }
                String label1 = tab1.getLabel();
                String label2 = tab2.getLabel();
                return Collator.getInstance().compare(label1, label2);
            }

            private Tab getPreviousTab(Tab tab) {
                Tab afterTab = tab.getAfterTab();
                if (tabsList.contains(afterTab)) {
                    return afterTab;
                }
                return null;
            }

            private int getPriority(Tab tab) {
                Tab previousTab = this.getPreviousTab(tab);
                if (previousTab != null) {
                    return this.getPriority(previousTab) + 1;
                }
                return this.getXWTTabPriority(tab);
            }

            private int getXWTTabPriority(Tab tab) {
                return tab.getPriority();
            }
        });
        LinkedHashMap<Tab, Composite> tabs = new LinkedHashMap<Tab, Composite>();
        if (allTabs.size() > 1) {
            CTabFolder tabFolder = new CTabFolder(parent, 1024);
            tabFolder.setSelectionBackground(new Color[]{tabFolder.getDisplay().getSystemColor(1), tabFolder.getBackground()}, new int[]{100}, true);
            tabFolder.setLayout((Layout)new FillLayout());
            for (Tab tab : allTabs) {
                CTabItem item = new CTabItem(tabFolder, 0);
                Composite tabControl = new Composite((Composite)tabFolder, 0);
                item.setControl((Control)tabControl);
                item.setText(tab.getLabel());
                tabs.put(tab, tabControl);
            }
        } else if (!allTabs.isEmpty()) {
            Tab tab = (Tab)allTabs.get(0);
            tabs.put(tab, parent);
        }
        for (View view : this.views) {
            for (Section section : view.getSections()) {
                XWTSection xwtSection = new XWTSection(section, view, display);
                this.sections.add(xwtSection);
                xwtSection.createControls((Composite)tabs.get(section.getTab()), null);
                xwtSection.setInput(null, (ISelection)selection);
                xwtSection.refresh();
            }
        }
        this.getShell().pack();
        Point size = this.getShell().getSize();
        int minWidth = 600;
        if (size.x < minWidth) {
            size.x = minWidth;
        }
        this.getShell().setSize(size);
    }

    public void dispose() {
        for (XWTSection section : this.sections) {
            section.dispose();
        }
        this.sections.clear();
    }

    protected void okPressed() {
        this.getOkButton().forceFocus();
        super.okPressed();
    }
}

