/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.runtime;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.views.properties.Activator;
import org.eclipse.papyrus.views.properties.catalog.PropertiesURIHandler;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.contexts.Section;
import org.eclipse.papyrus.views.properties.contexts.Tab;
import org.eclipse.papyrus.views.properties.contexts.View;
import org.eclipse.papyrus.views.properties.modelelement.DataSource;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationManager;
import org.eclipse.papyrus.views.properties.runtime.DisplayEngine;
import org.eclipse.papyrus.views.properties.runtime.SectionDiscriminator;
import org.eclipse.papyrus.views.properties.runtime.TabModel;
import org.eclipse.papyrus.views.properties.util.EMFURLStreamHandler;
import org.eclipse.papyrus.views.properties.xwt.XWTTabDescriptor;
import org.eclipse.papyrus.xwt.DefaultLoadingContext;
import org.eclipse.papyrus.xwt.ILoadingContext;
import org.eclipse.papyrus.xwt.IXWTLoader;
import org.eclipse.papyrus.xwt.XWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDisplayEngine
implements DisplayEngine {
    private ILoadingContext loadingContext = new DefaultLoadingContext(this.getClass().getClassLoader());
    private Map<String, XWTTabDescriptor> currentTabs = new HashMap<String, XWTTabDescriptor>();
    private TabModel<DataSource> displayedSections = new TabModel();
    private TabModel<Control> controls = new TabModel();
    private boolean allowDuplicate;
    private Object xmlCache;

    public DefaultDisplayEngine() {
        this(false);
    }

    public DefaultDisplayEngine(boolean allowDuplicate) {
        this.allowDuplicate = allowDuplicate;
    }

    @Override
    public List<ITabDescriptor> getTabDescriptors(Set<View> views) {
        LinkedHashMap<String, XWTTabDescriptor> result = new LinkedHashMap<String, XWTTabDescriptor>();
        HashSet<String> selectedSections = new HashSet<String>();
        for (View view : views) {
            for (Section section : view.getSections()) {
                XWTTabDescriptor descriptor;
                if (selectedSections.contains(section.getName())) continue;
                Tab tab = section.getTab();
                if (tab == null) {
                    Activator.log.warn("Null tab for " + section);
                    continue;
                }
                if (result.containsKey(tab.getId())) {
                    descriptor = (XWTTabDescriptor)((Object)result.get(tab.getId()));
                } else {
                    descriptor = new XWTTabDescriptor(tab);
                    result.put(tab.getId(), descriptor);
                }
                descriptor.addSection(section, view, this);
                selectedSections.add(section.getName());
            }
        }
        for (Map.Entry entry : result.entrySet()) {
            XWTTabDescriptor existing = this.currentTabs.get(entry.getKey());
            if (existing == null || existing.equals(entry.getValue())) continue;
            this.disposeControls((String)entry.getKey());
        }
        this.currentTabs = result;
        return new ArrayList<ITabDescriptor>(result.values());
    }

    protected void disposeControls(Section section) {
        DataSource dataSource;
        Control control = this.controls.remove(section);
        if (control != null) {
            control.dispose();
        }
        if ((dataSource = this.displayedSections.remove(section)) != null) {
            dataSource.dispose();
        }
    }

    protected void disposeControls(String tabID) {
        for (Control control : this.controls.remove(tabID)) {
            control.dispose();
        }
        for (DataSource dataSource : this.displayedSections.remove(tabID)) {
            dataSource.dispose();
        }
    }

    protected void disposeControls() {
        for (String next : new ArrayList<String>(this.controls.tabIDs())) {
            this.disposeControls(next);
        }
    }

    @Override
    public void dispose() {
        this.disposeControls();
    }

    public void invalidate() {
        this.xmlCache = null;
    }

    @Override
    public Control createSection(Composite parent, Section section, DataSource source) {
        if (source == null) {
            return null;
        }
        DataSource existing = this.getDataSource(section);
        if (!this.allowDuplicate && existing != null) {
            if (this.isUnloaded(existing) || this.conflictingArity(existing.getSelection(), source.getSelection())) {
                this.disposeControls(section);
            } else {
                existing.setSelection(source.getSelection());
                return null;
            }
        }
        Control control = this.createSection(parent, section, this.loadXWTFile(section), source);
        this.addDataSource(section, source);
        if (control != null) {
            this.addControl(section, control);
        }
        return control;
    }

    protected DataSource getDataSource(Section section) {
        return this.displayedSections.get(section);
    }

    protected boolean isUnloaded(DataSource dataSource) {
        boolean result = false;
        Iterator iter = dataSource.getSelection().iterator();
        while (!result && iter.hasNext()) {
            EObject next = EMFHelper.getEObject(iter.next());
            boolean bl = result = next != null && next.eIsProxy();
        }
        return result;
    }

    protected boolean conflictingArity(IStructuredSelection selection1, IStructuredSelection selection2) {
        return selection1.size() <= 1 ^ selection2.size() <= 1;
    }

    protected DataSource addDataSource(Section section, DataSource dataSource) {
        return this.displayedSections.put(section, dataSource);
    }

    protected void addControl(final Section section, Control control) {
        this.controls.put(section, control);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DefaultDisplayEngine.this.displayedSections.remove(section);
                DefaultDisplayEngine.this.controls.remove(section);
            }
        });
    }

    @Override
    public void refreshSection(Composite parent, Section section, DataSource source) {
        Control control;
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        control = this.createSection(parent, section, this.loadXWTFile(section), source);
        this.addDataSource(section, source);
        if (control != null) {
            this.addControl(section, control);
        }
    }

    @Override
    public Control createSection(Composite parent, Section section, URI sectionFile, DataSource source) {
        if (sectionFile == null && (sectionFile = this.loadXWTFile(section)) == null) {
            return null;
        }
        ILoadingContext xwtContext = XWT.getLoadingContext();
        XWT.setLoadingContext((ILoadingContext)this.loadingContext);
        Control control = null;
        try {
            ResourceSet rset = section.eResource().getResourceSet();
            URL url = new URL(null, sectionFile.toString(), new EMFURLStreamHandler(rset.getURIConverter()));
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("XWT.Container", parent);
            options.put("XWT.DataContext", source);
            options.put(IXWTLoader.XML_CACHE_PROPERTY, this.xmlCache != null ? this.xmlCache : Boolean.TRUE);
            control = (Control)XWT.loadWithOptions((URL)url, options);
            this.xmlCache = options.get(IXWTLoader.XML_CACHE_PROPERTY);
            if (control != null) {
                control.setLayoutData((Object)new GridData(4, 4, true, true));
                this.addControl(section, control);
            }
        }
        catch (Exception ex) {
            Activator.log.error("Error while loading " + section.getSectionFile(), (Throwable)ex);
            this.disposeControls(section.getTab().getId());
            Label label = new Label(parent, 0);
            label.setText("An error occured in the property view. The file " + section.getSectionFile() + " could not be loaded");
        }
        this.layout(parent);
        XWT.setLoadingContext((ILoadingContext)xwtContext);
        return control;
    }

    private URI loadXWTFile(Section section) {
        EObject tab = section.eContainer();
        Context context = (Context)tab.eContainer();
        if (context.eResource() == null) {
            context = ConfigurationManager.getInstance().getContext(context.getName());
            Activator.log.warn("No resource for Context : " + context + " ; refreshing the model");
        }
        URI sectionURI = URI.createURI((String)section.getSectionFile());
        URI baseURI = context.eResource().getURI();
        if ("ppe".equals(baseURI.scheme())) {
            PropertiesURIHandler handler = new PropertiesURIHandler();
            baseURI = handler.getConvertedURI(baseURI);
        }
        sectionURI = sectionURI.resolve(baseURI);
        return sectionURI;
    }

    private void layout(Composite parent) {
        parent.getParent().getParent().layout();
        parent.getParent().layout();
        parent.layout();
    }

    @Override
    public void removeSection(Composite parent) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        this.layout(parent);
    }

    public static Section discriminate(Section section, Object discriminator) {
        if (section == null) {
            throw new IllegalArgumentException("null section");
        }
        if (discriminator == null) {
            throw new IllegalArgumentException("null discriminator");
        }
        if (SectionDiscriminator.isDiscriminated(section)) {
            throw new IllegalArgumentException("section already has a discriminator");
        }
        return SectionDiscriminator.discriminate(section, discriminator);
    }

    public static Object getDiscriminator(Section section) {
        if (section == null) {
            throw new IllegalArgumentException("null section");
        }
        return SectionDiscriminator.getDiscriminator(section);
    }
}

