/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.util;

import java.util.Collection;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.constraints.runtime.ConstraintEngine;
import org.eclipse.papyrus.views.properties.contexts.View;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationManager;
import org.eclipse.papyrus.views.properties.runtime.DisplayEngine;
import org.eclipse.papyrus.views.properties.runtime.EmbeddedDisplayEngine;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesDisplayHelper {
    public static DisplayEngine display(Object selection, Composite parent) {
        return PropertiesDisplayHelper.display(PropertiesDisplayHelper.getDefaultConstraintEngine(), (ISelection)PropertiesDisplayHelper.buildSelection(selection), parent);
    }

    public static DisplayEngine display(Collection<?> selection, Composite parent) {
        return PropertiesDisplayHelper.display(PropertiesDisplayHelper.getDefaultConstraintEngine(), (ISelection)PropertiesDisplayHelper.buildSelection(selection), parent);
    }

    public static DisplayEngine display(ConstraintEngine<? extends View> constraints, Object selection, Composite parent) {
        return PropertiesDisplayHelper.display(constraints, (ISelection)PropertiesDisplayHelper.buildSelection(selection), parent);
    }

    public static DisplayEngine display(ConstraintEngine<? extends View> constraints, Collection<?> selection, Composite parent) {
        return PropertiesDisplayHelper.display(constraints, (ISelection)PropertiesDisplayHelper.buildSelection(selection), parent);
    }

    public static DisplayEngine display(ConstraintEngine<? extends View> constraints, ISelection selection, Composite parent) {
        EmbeddedDisplayEngine display = new EmbeddedDisplayEngine();
        Set views = constraints.getDisplayUnits(selection);
        display.display(views, parent, selection, 0);
        return display;
    }

    public static ConstraintEngine<? extends View> getDefaultConstraintEngine() {
        return ConfigurationManager.getInstance().getConstraintEngine();
    }

    private static IStructuredSelection buildSelection(Collection<?> elements) {
        return new StructuredSelection(elements);
    }

    private static IStructuredSelection buildSelection(Object element) {
        return new StructuredSelection(element);
    }
}

