/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.xwt;

import java.util.List;
import org.eclipse.papyrus.views.properties.Activator;
import org.eclipse.papyrus.views.properties.contexts.Section;
import org.eclipse.papyrus.views.properties.contexts.Tab;
import org.eclipse.papyrus.views.properties.contexts.View;
import org.eclipse.papyrus.views.properties.runtime.DisplayEngine;
import org.eclipse.papyrus.views.properties.xwt.XWTSectionDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.tabbed.AbstractTabDescriptor;

public class XWTTabDescriptor
extends AbstractTabDescriptor {
    private Tab tab;

    public XWTTabDescriptor(Tab tab) {
        this.tab = tab;
    }

    public void addSection(Section section, View view, DisplayEngine display) {
        super.getSectionDescriptors().add(new XWTSectionDescriptor(section, view, display));
    }

    public String getCategory() {
        String category = this.tab.getCategory();
        return category == null ? "" : category;
    }

    public String getId() {
        return this.tab.getId();
    }

    public String getLabel() {
        return this.tab.getLabel();
    }

    public Image getImage() {
        String imagePath = this.tab.getImage();
        if (imagePath == null || imagePath.trim().equals("")) {
            return null;
        }
        return Activator.getDefault().getImageFromPlugin(imagePath);
    }

    public boolean isIndented() {
        return this.tab.isIndented();
    }

    public String getAfterTab() {
        if (this.tab.getAfterTab() != null) {
            return this.tab.getAfterTab().getId();
        }
        return super.getAfterTab();
    }

    public String toString() {
        return "Tab " + this.getLabel() + " => " + this.getSectionDescriptors();
    }

    public int getPriority() {
        return this.tab.getPriority();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        List sectionDescriptors = this.getSectionDescriptors();
        result = 31 * result + (this.tab == null ? 0 : this.tab.hashCode());
        result = 31 * result + (sectionDescriptors == null ? 0 : sectionDescriptors.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        boolean result;
        if (this == obj) {
            result = true;
        } else if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            result = false;
        } else {
            XWTTabDescriptor other = (XWTTabDescriptor)((Object)obj);
            boolean bl = other.getId() == null ? this.getId() == null : (result = other.getId().equals(this.getId()));
            if (result) {
                result = other.getSectionDescriptors() == null ? this.getSectionDescriptors() == null : other.getSectionDescriptors().equals(this.getSectionDescriptors());
            }
        }
        return result;
    }
}

