/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.xwt.converters;

import org.eclipse.papyrus.xwt.converters.AbstractMultiValueConverter;

public class StringMultiValueConerter
extends AbstractMultiValueConverter {
    private String separatorExpression = null;

    public Object[] convertBack(Object value) {
        if (value instanceof Object[]) {
            return (Object[])value;
        }
        String valueString = value.toString();
        return valueString.split(this.getSeparatorExpression());
    }

    public String getSeparatorExpression() {
        if (this.separatorExpression == null) {
            return "[ \t\r\n]+";
        }
        return this.separatorExpression;
    }

    public void setSeparatorExpression(String separatorExpression) {
        this.separatorExpression = separatorExpression;
    }

    protected String getSeparator() {
        if (this.separatorExpression == null || this.separatorExpression.length() == 0) {
            return " ";
        }
        return "" + this.separatorExpression.charAt(0);
    }

    public Object convert(Object[] value) {
        StringBuffer buffer = new StringBuffer();
        String separator = this.getSeparator();
        int i = 0;
        while (i < value.length) {
            if (i != 0) {
                buffer.append(separator);
            }
            buffer.append(value[i]);
            ++i;
        }
        return buffer.toString();
    }

    public Object getFromType() {
        return String[].class;
    }

    public Object getToType() {
        return String.class;
    }
}

