/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.editor.actions;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.ptp.internal.rdt.editor.RemoteCEditor;
import org.eclipse.ptp.internal.rdt.editor.preferences.PrintPreferencePage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextPrintOptions;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Display;

public class PrintAction
extends Action {
    private RemoteCEditor _editor;

    public PrintAction(IAction print, RemoteCEditor remoteCEditor) {
        super(print.getText(), print.getImageDescriptor());
        this.setActionDefinitionId(print.getActionDefinitionId());
        this._editor = remoteCEditor;
    }

    public void run() {
        StyledText widget = this._editor.getViewer().getTextWidget();
        Printer printer = this.getPrinter();
        if (printer != null) {
            Font oldFont = widget.getFont();
            Font newFont = PrintPreferencePage.getSavedFont();
            widget.setRedraw(false);
            widget.setFont(newFont);
            Point screenDPI = widget.getDisplay().getDPI();
            GC gc = new GC((Drawable)printer);
            gc.setFont(widget.getFont());
            int charWidth = Math.max(gc.getFontMetrics().getAverageCharWidth(), gc.getCharWidth('W'));
            Point padding = new Point(screenDPI.x / charWidth, screenDPI.y / gc.getFontMetrics().getHeight());
            gc.dispose();
            Runnable r = widget.print(printer, this.getStyleOptions(padding));
            Display display = Display.getCurrent();
            display.syncExec(r);
            widget.setFont(oldFont);
            widget.setRedraw(true);
            widget.redraw();
            printer.dispose();
            newFont.dispose();
        }
    }

    private Printer getPrinter() {
        PrintDialog dialog;
        PrinterData data;
        Display display = Display.getCurrent();
        if (display != null && (data = (dialog = new PrintDialog(display.getActiveShell())).open()) != null) {
            return new Printer(data);
        }
        return null;
    }

    private StyledTextPrintOptions getStyleOptions(Point padding) {
        StyledTextPrintOptions options = new StyledTextPrintOptions();
        StringBuilder pad = new StringBuilder();
        int i = 0;
        while (i < padding.x) {
            pad.append(' ');
            ++i;
        }
        options.footer = String.valueOf(this.doSubstitutions(PrintPreferencePage.getFooter())) + pad;
        options.header = String.valueOf(this.doSubstitutions(PrintPreferencePage.getHeader())) + pad;
        options.jobName = this._editor.getTitle();
        options.printTextFontStyle = true;
        options.printTextForeground = true;
        options.printTextBackground = true;
        options.printLineNumbers = PrintPreferencePage.getPrintLineNumbers();
        if (options.printLineNumbers) {
            options.lineLabels = new String[this._editor.getViewer().getTextWidget().getLineCount()];
            i = 0;
            while (i < options.lineLabels.length) {
                options.lineLabels[i] = String.valueOf(JFaceTextUtil.widgetLine2ModelLine((ITextViewer)this._editor.getViewer(), (int)i) + 1);
                ++i;
            }
        }
        return options;
    }

    private String doSubstitutions(String text) {
        text = text.replace("<date>", DateFormat.getDateInstance(1).format(new Date()));
        text = text.replace("<time>", DateFormat.getTimeInstance(1).format(new Date()));
        text = text.replace("<file>", this._editor.getTitle());
        return text;
    }
}

