/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.managedbuilder.xlc.ui.properties;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.ptp.rdt.managedbuilder.xlc.ui.messages.Messages;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteServices;
import org.eclipse.remote.ui.IRemoteUIFileManager;
import org.eclipse.remote.ui.IRemoteUIServices;
import org.eclipse.remote.ui.RemoteUIServices;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class RemoteDirectoryFieldEditor
extends DirectoryFieldEditor {
    protected IRemoteConnection fRemoteConnection;
    private IFileStore fCurrentRemoteFileStore;
    private String fCurrentRemoteFilename;

    public RemoteDirectoryFieldEditor(String name, String labelText, Composite parent, IRemoteConnection connection) {
        super(name, labelText, parent);
        this.fRemoteConnection = connection;
    }

    protected String changePressed() {
        String remotePath = this.browseRemoteLocation(this.getShell(), this.getTextControl().getText());
        if (remotePath != null) {
            this.getTextControl().setText(remotePath);
        }
        this.doCheckState();
        return remotePath;
    }

    public String browseRemoteLocation(Shell shell, String path) {
        IRemoteUIFileManager fileMgr;
        IRemoteUIServices remoteUIServices = RemoteUIServices.getRemoteUIServices((IRemoteServices)this.fRemoteConnection.getRemoteServices());
        if (remoteUIServices != null && (fileMgr = remoteUIServices.getUIFileManager()) != null) {
            fileMgr.setConnection(this.fRemoteConnection);
            String correctPath = path;
            String selectedPath = fileMgr.browseDirectory(shell, Messages.getString("RemoteDirectoryFieldEditor_0", this.fRemoteConnection.getName()), correctPath, 0);
            return selectedPath;
        }
        return null;
    }

    private void updateCurrentRemoteFile() {
        String dirName = this.getTextControl().getText();
        if (this.fCurrentRemoteFilename == null || !this.fCurrentRemoteFilename.equals(dirName)) {
            this.fCurrentRemoteFilename = dirName;
            this.fCurrentRemoteFileStore = null;
            if (this.fRemoteConnection != null) {
                this.fCurrentRemoteFileStore = this.fRemoteConnection.getFileManager().getResource(dirName);
            }
        }
    }

    protected boolean doCheckState() {
        this.updateCurrentRemoteFile();
        if (this.fCurrentRemoteFileStore != null) {
            return this.fCurrentRemoteFileStore.fetchInfo().exists();
        }
        return false;
    }
}

