/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.internal.ui.actions.CDTQuickMenuCreator;
import org.eclipse.cdt.internal.ui.editor.AddIncludeAction;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.SortLinesAction;
import org.eclipse.cdt.ui.actions.FormatAllAction;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.AddBookmarkAction;
import org.eclipse.ui.actions.AddTaskAction;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class GenerateActionGroup
extends ActionGroup
implements ISelectionChangedListener {
    public static final String MENU_ID = "org.eclipse.cdt.ui.source.menu";
    public static final String GROUP_ORGANIZE = "organizeGroup";
    public static final String GROUP_GENERATE = "generateGroup";
    public static final String GROUP_CODE = "codeGroup";
    private static final String GROUP_EXTERNALIZE = "externalizeGroup";
    private static final String GROUP_COMMENT = "commentGroup";
    private static final String GROUP_EDIT = "editGroup";
    private CEditor fEditor;
    private IWorkbenchSite fSite;
    private String fGroupName = "group.reorganize";
    private List<ISelectionChangedListener> fRegisteredSelectionListeners;
    private AddIncludeAction fAddInclude;
    private AddBookmarkAction fAddBookmark;
    private AddTaskAction fAddTaskAction;
    private SortLinesAction fSortLines;
    private FormatAllAction fFormatAll;
    private static final String QUICK_MENU_ID = "org.eclipse.cdt.ui.edit.text.c.source.quickMenu";
    private IHandlerActivation fQuickAccessHandlerActivation;
    private IHandlerService fHandlerService;

    public GenerateActionGroup(CEditor editor, String groupName) {
        this.fSite = editor.getSite();
        this.fEditor = editor;
        this.fGroupName = groupName;
        this.fAddInclude = new AddIncludeAction((ITextEditor)editor);
        this.fAddInclude.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.add.include");
        editor.setAction("AddInclude", (IAction)this.fAddInclude);
        this.fSortLines = new SortLinesAction((ITextEditor)editor);
        this.fSortLines.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.sort.lines");
        editor.setAction("SortLines", (IAction)this.fSortLines);
        this.installQuickAccessAction();
    }

    public GenerateActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite(), null);
    }

    public GenerateActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getSite(), (IHandlerService)part.getSite().getService(IHandlerService.class));
    }

    private GenerateActionGroup(IWorkbenchSite site, IHandlerService handlerService) {
        this.fSite = site;
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.fAddBookmark = new AddBookmarkAction((IShellProvider)site, true);
        this.fAddBookmark.setActionDefinitionId("org.eclipse.ui.edit.addBookmark");
        this.fAddTaskAction = new AddTaskAction((IShellProvider)site);
        this.fAddTaskAction.setActionDefinitionId("org.eclipse.ui.edit.addTask");
        this.fFormatAll = new FormatAllAction(site);
        this.fFormatAll.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.format");
        this.fFormatAll.update(selection);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            this.fAddBookmark.selectionChanged(ss);
            this.fAddTaskAction.selectionChanged(ss);
        } else {
            this.fAddBookmark.setEnabled(false);
            this.fAddTaskAction.setEnabled(false);
        }
        this.registerSelectionListener(provider, (ISelectionChangedListener)this.fAddBookmark);
        this.registerSelectionListener(provider, (ISelectionChangedListener)this.fFormatAll);
        this.registerSelectionListener(provider, (ISelectionChangedListener)this.fAddTaskAction);
        this.selectionChanged(new SelectionChangedEvent(provider, selection));
        this.registerSelectionListener(provider, this);
        this.installQuickAccessAction();
    }

    private void installQuickAccessAction() {
        this.fHandlerService = (IHandlerService)this.fSite.getService(IHandlerService.class);
        if (this.fHandlerService != null) {
            IHandler handler = new CDTQuickMenuCreator(this.fEditor){

                protected void fillMenu(IMenuManager menu) {
                    GenerateActionGroup.this.fillQuickMenu(menu);
                }
            }.createHandler();
            this.fQuickAccessHandlerActivation = this.fHandlerService.activateHandler(QUICK_MENU_ID, handler);
        }
    }

    private void registerSelectionListener(ISelectionProvider provider, ISelectionChangedListener listener) {
        if (this.fRegisteredSelectionListeners == null) {
            this.fRegisteredSelectionListeners = new ArrayList<ISelectionChangedListener>(10);
        }
        provider.addSelectionChangedListener(listener);
        this.fRegisteredSelectionListeners.add(listener);
    }

    public void editorStateChanged() {
        Assert.isTrue((boolean)this.isEditorOwner());
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.setGlobalActionHandlers(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        MenuManager subMenu = new MenuManager(ActionMessages.SourceMenu_label, MENU_ID);
        subMenu.setActionDefinitionId(QUICK_MENU_ID);
        int added = 0;
        added = this.isEditorOwner() ? this.fillEditorSubMenu((IMenuManager)subMenu) : this.fillViewSubMenu((IMenuManager)subMenu);
        if (added > 0) {
            menu.appendToGroup(this.fGroupName, (IContributionItem)subMenu);
        }
    }

    private void fillQuickMenu(IMenuManager menu) {
        if (this.isEditorOwner()) {
            this.fillEditorSubMenu(menu);
        } else {
            this.fillViewSubMenu(menu);
        }
    }

    private int fillEditorSubMenu(IMenuManager source) {
        int added = 0;
        source.add((IContributionItem)new Separator(GROUP_COMMENT));
        added += this.addEditorAction(source, "ToggleComment");
        added += this.addEditorAction(source, "AddBlockComment");
        added += this.addEditorAction(source, "RemoveBlockComment");
        source.add((IContributionItem)new Separator(GROUP_EDIT));
        added += this.addEditorAction(source, "ShiftRight");
        added += this.addEditorAction(source, "ShiftLeft");
        added += this.addEditorAction(source, "Indent");
        added += this.addEditorAction(source, "Format");
        source.add((IContributionItem)new Separator(GROUP_ORGANIZE));
        added += this.addAction(source, (IAction)this.fAddInclude);
        source.add((IContributionItem)new Separator(GROUP_GENERATE));
        source.add((IContributionItem)new Separator(GROUP_CODE));
        source.add((IContributionItem)new Separator(GROUP_EXTERNALIZE));
        return added += this.addAction(source, (IAction)this.fSortLines);
    }

    private int fillViewSubMenu(IMenuManager source) {
        int added = 0;
        source.add((IContributionItem)new Separator(GROUP_COMMENT));
        source.add((IContributionItem)new Separator(GROUP_EDIT));
        added += this.addAction(source, (IAction)this.fFormatAll);
        source.add((IContributionItem)new Separator(GROUP_ORGANIZE));
        source.add((IContributionItem)new Separator(GROUP_GENERATE));
        source.add((IContributionItem)new Separator(GROUP_CODE));
        source.add((IContributionItem)new Separator(GROUP_EXTERNALIZE));
        return added += this.addAction(source, (IAction)this.fAddInclude);
    }

    public void dispose() {
        if (this.fRegisteredSelectionListeners != null) {
            ISelectionProvider provider = this.fSite.getSelectionProvider();
            for (ISelectionChangedListener listener : this.fRegisteredSelectionListeners) {
                provider.removeSelectionChangedListener(listener);
            }
        }
        if (this.fQuickAccessHandlerActivation != null && this.fHandlerService != null) {
            this.fHandlerService.deactivateHandler(this.fQuickAccessHandlerActivation);
        }
        this.fEditor = null;
        super.dispose();
    }

    private void setGlobalActionHandlers(IActionBars actionBar) {
        actionBar.setGlobalActionHandler("org.eclipse.cdt.ui.actions.AddInclude", (IAction)this.fAddInclude);
        if (!this.isEditorOwner()) {
            actionBar.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), (IAction)this.fAddBookmark);
            actionBar.setGlobalActionHandler(IDEActionFactory.ADD_TASK.getId(), (IAction)this.fAddTaskAction);
            actionBar.setGlobalActionHandler("org.eclipse.cdt.ui.actions.Format", (IAction)this.fFormatAll);
        }
    }

    private int addAction(IMenuManager menu, IAction action) {
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
        if (action != null && action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    private int addEditorAction(IMenuManager menu, String actionID) {
        if (this.fEditor == null) {
            return 0;
        }
        IAction action = this.fEditor.getAction(actionID);
        if (action == null) {
            return 0;
        }
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
        if (action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    private boolean isEditorOwner() {
        return this.fEditor != null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
    }
}

