/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.navigation;

import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.internal.rdt.core.RemoteIndexerInfoProviderFactory;
import org.eclipse.ptp.internal.rdt.core.RemoteScannerInfo;
import org.eclipse.ptp.internal.rdt.core.model.ModelAdapter;
import org.eclipse.ptp.internal.rdt.core.model.Scope;
import org.eclipse.ptp.internal.rdt.core.model.TranslationUnit;
import org.eclipse.ptp.internal.rdt.core.model.WorkingCopy;
import org.eclipse.ptp.internal.rdt.core.navigation.OpenDeclarationResult;
import org.eclipse.ptp.internal.rdt.core.serviceproviders.AbstractRemoteService;
import org.eclipse.ptp.internal.rdt.core.subsystems.ICIndexSubsystem;
import org.eclipse.ptp.internal.rdt.ui.navigation.INavigationService;
import org.eclipse.ptp.rdt.core.RDTLog;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.ui.texteditor.ITextEditor;

public class RemoteNavigationService
extends AbstractRemoteService
implements INavigationService {
    public RemoteNavigationService(IConnectorService connectorService) {
        super(connectorService);
    }

    public RemoteNavigationService(ICIndexSubsystem subsystem) {
        super(subsystem);
    }

    @Override
    public OpenDeclarationResult openDeclaration(ITextEditor editor, String selectedText, int selectionStart, int selectionLength, IProgressMonitor monitor) {
        IWorkingCopy workingCopy = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editor.getEditorInput());
        if (editor.isDirty()) {
            String contents = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).get();
            workingCopy = new WorkingCopy(null, (ITranslationUnit)workingCopy, contents);
        } else {
            try {
                workingCopy = (ITranslationUnit)ModelAdapter.adaptElement(null, (ICElement)workingCopy, (int)0, (boolean)true);
            }
            catch (CModelException e) {
                RDTLog.logError((Throwable)e);
                return OpenDeclarationResult.failureUnexpectedError();
            }
        }
        ICIndexSubsystem subsystem = this.getSubSystem();
        subsystem.checkProject(workingCopy.getCProject().getProject(), monitor);
        if (workingCopy instanceof TranslationUnit) {
            RemoteScannerInfo scannerInfo = workingCopy.getResource() == null ? RemoteIndexerInfoProviderFactory.getScannerInfo((IResource)workingCopy.getCProject().getProject()) : RemoteIndexerInfoProviderFactory.getScannerInfo((IResource)workingCopy.getResource());
            Map langaugeProperties = null;
            try {
                String languageId = workingCopy.getLanguage().getId();
                IProject project = workingCopy.getCProject().getProject();
                langaugeProperties = RemoteIndexerInfoProviderFactory.getLanguageProperties((String)languageId, (IProject)project);
            }
            catch (Exception e) {
                RDTLog.logError((Throwable)e);
            }
            if (workingCopy instanceof TranslationUnit) {
                ((TranslationUnit)workingCopy).setASTContext((IScannerInfo)scannerInfo, langaugeProperties);
            }
        }
        Scope scope = new Scope(workingCopy.getCProject().getProject());
        return subsystem.openDeclaration(scope, (ITranslationUnit)workingCopy, selectedText, selectionStart, selectionLength, monitor);
    }
}

