/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.remotetools.core;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ptp.internal.remote.remotetools.core.RemoteToolsAdapterCorePlugin;
import org.eclipse.ptp.internal.remote.remotetools.core.RemoteToolsConnectionWorkingCopy;
import org.eclipse.ptp.internal.remote.remotetools.core.RemoteToolsFileManager;
import org.eclipse.ptp.internal.remote.remotetools.core.RemoteToolsProcessBuilder;
import org.eclipse.ptp.internal.remote.remotetools.core.messages.Messages;
import org.eclipse.ptp.remotetools.core.IPortForwarding;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.core.IRemotePortForwarding;
import org.eclipse.ptp.remotetools.core.IRemoteTunnel;
import org.eclipse.ptp.remotetools.environment.EnvironmentPlugin;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.ptp.remotetools.environment.core.ITargetElement;
import org.eclipse.ptp.remotetools.environment.core.ITargetEventListener;
import org.eclipse.ptp.remotetools.environment.core.TargetElement;
import org.eclipse.ptp.remotetools.environment.core.TargetEnvironmentManager;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.LocalPortBoundException;
import org.eclipse.ptp.remotetools.exception.PortForwardingException;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionChangeEvent;
import org.eclipse.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.IRemoteFileManager;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteProcessBuilder;
import org.eclipse.remote.core.IRemoteServices;
import org.eclipse.remote.core.IUserAuthenticator;
import org.eclipse.remote.core.exception.AddressInUseException;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.core.exception.UnableToForwardPortException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteToolsConnection
implements IRemoteConnection {
    private String fWorkingDir;
    private Map<String, String> fEnv;
    private Map<String, String> fProperties;
    private final Map<Integer, IRemoteTunnel> fTunnels = new HashMap<Integer, IRemoteTunnel>();
    private final IRemoteServices fRemoteServices;
    private final TargetElement fTargetElement;
    private final ITargetControl fTargetControl;
    private final RemoteToolsFileManager fFileManager = new RemoteToolsFileManager(this);
    private final ListenerList fListeners = new ListenerList();
    private final ITargetEventListener fTargetEventListener = new ITargetEventListener(){

        public void handleStateChangeEvent(int event, ITargetElement element) {
            if (element.getName().equals(RemoteToolsConnection.this.fTargetElement.getName()) && event == 1) {
                RemoteToolsConnection.this.doClose();
            }
        }
    };

    public RemoteToolsConnection(String name, TargetElement element, IRemoteServices services) {
        this.fTargetElement = element;
        try {
            this.fTargetControl = element.getControl();
        }
        catch (CoreException e) {
            RemoteToolsAdapterCorePlugin.log(e);
            throw new RuntimeException(e.getMessage());
        }
        this.fTargetElement.setName(name);
        this.fRemoteServices = services;
        TargetEnvironmentManager targetMgr = EnvironmentPlugin.getDefault().getTargetsManager();
        targetMgr.addModelEventListener(this.fTargetEventListener);
    }

    public void addConnectionChangeListener(IRemoteConnectionChangeListener listener) {
        this.fListeners.add((Object)listener);
    }

    public synchronized void close() {
        if (this.isOpen()) {
            try {
                this.fTargetControl.kill();
            }
            catch (CoreException coreException) {}
            this.doClose();
        }
    }

    public int compareTo(IRemoteConnection o) {
        return this.getName().compareTo(o.getName());
    }

    public IRemoteExecutionManager createExecutionManager() throws org.eclipse.ptp.remotetools.exception.RemoteConnectionException {
        return this.fTargetControl.createExecutionManager();
    }

    public void dispose() {
        TargetEnvironmentManager targetMgr = EnvironmentPlugin.getDefault().getTargetsManager();
        targetMgr.removeModelEventListener(this.fTargetEventListener);
        this.fTargetElement.getType().removeElement((ITargetElement)this.fTargetElement);
        this.fListeners.clear();
    }

    private void doClose() {
        this.fWorkingDir = null;
    }

    public void fireConnectionChangeEvent(final int type) {
        IRemoteConnectionChangeEvent event = new IRemoteConnectionChangeEvent(){

            public IRemoteConnection getConnection() {
                return RemoteToolsConnection.this;
            }

            public int getType() {
                return type;
            }
        };
        Object[] objectArray = this.fListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRemoteConnectionChangeListener)listener).connectionChanged(event);
            ++n2;
        }
    }

    public void forwardLocalPort(int localPort, String fwdAddress, int fwdPort) throws RemoteConnectionException {
        if (!this.isOpen()) {
            throw new RemoteConnectionException(Messages.RemoteToolsConnection_connectionNotOpen);
        }
        if (this.fTunnels.get(localPort) != null) {
            throw new RemoteConnectionException(Messages.RemoteToolsConnection_port_is_already_forwarded);
        }
        try {
            IRemoteTunnel tunnel = this.fTargetControl.getExecutionManager().createTunnel(localPort, fwdAddress, fwdPort);
            this.fTunnels.put(localPort, tunnel);
        }
        catch (LocalPortBoundException e) {
            throw new AddressInUseException(e.getMessage());
        }
        catch (org.eclipse.ptp.remotetools.exception.RemoteConnectionException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
        catch (CancelException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
    }

    public int forwardLocalPort(String fwdAddress, int fwdPort, IProgressMonitor monitor) throws RemoteConnectionException {
        if (!this.isOpen()) {
            throw new RemoteConnectionException(Messages.RemoteToolsConnection_connectionNotOpen);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        progress.beginTask(Messages.RemoteToolsConnection_forwarding, 10);
        int localPort = fwdPort + 1;
        if (!progress.isCanceled()) {
            try {
                this.forwardLocalPort(localPort, fwdAddress, fwdPort);
            }
            catch (AddressInUseException addressInUseException) {
                if (++localPort == fwdPort) {
                    throw new UnableToForwardPortException(Messages.RemoteToolsConnection_remotePort);
                }
                progress.worked(1);
            }
            return localPort;
        }
        return -1;
    }

    public void forwardRemotePort(int remotePort, String fwdAddress, int fwdPort) throws RemoteConnectionException {
        if (!this.isOpen()) {
            throw new RemoteConnectionException(Messages.RemoteToolsConnection_connectionNotOpen);
        }
        try {
            this.fTargetControl.getExecutionManager().getPortForwardingTools().forwardRemotePort(remotePort, fwdAddress, fwdPort);
        }
        catch (org.eclipse.ptp.remotetools.exception.RemoteConnectionException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
        catch (CancelException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
        catch (PortForwardingException e) {
            throw new AddressInUseException(e.getMessage());
        }
    }

    public int forwardRemotePort(String fwdAddress, int fwdPort, IProgressMonitor monitor) throws RemoteConnectionException {
        if (!this.isOpen()) {
            throw new RemoteConnectionException(Messages.RemoteToolsConnection_connectionNotOpen);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        progress.beginTask(Messages.RemoteToolsConnection_forwarding, 10);
        int remotePort = fwdPort + 1;
        while (!progress.isCanceled()) {
            try {
                this.forwardRemotePort(remotePort, fwdAddress, fwdPort);
                return remotePort;
            }
            catch (AddressInUseException addressInUseException) {
                if (++remotePort == fwdPort) {
                    throw new UnableToForwardPortException(Messages.RemoteToolsConnection_remotePort);
                }
                progress.worked(1);
            }
        }
        return -1;
    }

    public String getAddress() {
        return this.fTargetControl.getConfig().getConnectionAddress();
    }

    public Map<String, String> getAttributes() {
        return this.fTargetControl.getConfig().getAttributes().getAttributesAsMap();
    }

    public IRemoteProcess getCommandShell(int flags) throws IOException {
        throw new IOException("Not currently implemented");
    }

    public Map<String, String> getEnv() {
        if (this.fEnv == null) {
            this.fEnv = new HashMap<String, String>();
            IRemoteExecutionManager exeMgr = null;
            try {
                exeMgr = this.createExecutionManager();
            }
            catch (org.eclipse.ptp.remotetools.exception.RemoteConnectionException remoteConnectionException) {}
            if (exeMgr != null) {
                try {
                    String[] vars;
                    String env = exeMgr.getExecutionTools().executeWithOutput("printenv").trim();
                    String[] stringArray = vars = env.split("\n");
                    int n = vars.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String var = stringArray[n2];
                        String[] kv = var.split("=");
                        if (kv.length == 2) {
                            this.fEnv.put(kv[0], kv[1]);
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {}
            }
        }
        return Collections.unmodifiableMap(this.fEnv);
    }

    public String getEnv(String name) {
        this.getEnv();
        return this.fEnv.get(name);
    }

    public IRemoteFileManager getFileManager() {
        return this.fFileManager;
    }

    public String getName() {
        return this.fTargetElement.getName();
    }

    public int getPort() {
        return this.fTargetControl.getConfig().getConnectionPort();
    }

    public IRemoteProcessBuilder getProcessBuilder(List<String> command) {
        return new RemoteToolsProcessBuilder(this, this.fFileManager, command);
    }

    public IRemoteProcessBuilder getProcessBuilder(String ... command) {
        return new RemoteToolsProcessBuilder(this, this.fFileManager, command);
    }

    public String getProperty(String key) {
        this.loadProperties();
        return this.fProperties.get(key);
    }

    private String getPwd() {
        IRemoteExecutionManager exeMgr = null;
        try {
            exeMgr = this.createExecutionManager();
        }
        catch (org.eclipse.ptp.remotetools.exception.RemoteConnectionException remoteConnectionException) {}
        if (exeMgr != null) {
            try {
                return exeMgr.getExecutionTools().executeWithOutput("pwd").trim();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public IRemoteServices getRemoteServices() {
        return this.fRemoteServices;
    }

    public ITargetControl getTargetControl() {
        return this.fTargetControl;
    }

    public TargetElement getTargetElement() {
        return this.fTargetElement;
    }

    public String getUsername() {
        return this.fTargetControl.getConfig().getLoginUsername();
    }

    public IRemoteConnectionWorkingCopy getWorkingCopy() {
        return new RemoteToolsConnectionWorkingCopy(this);
    }

    public String getWorkingDirectory() {
        if (!this.isOpen()) {
            return "/";
        }
        if (this.fWorkingDir == null) {
            this.fWorkingDir = this.getPwd();
            if (this.fWorkingDir == null) {
                return "/";
            }
        }
        return this.fWorkingDir;
    }

    public synchronized boolean isOpen() {
        return this.fTargetControl.query() == 2;
    }

    private void loadProperties() {
        if (this.fProperties == null) {
            this.fProperties = new HashMap<String, String>();
            this.fProperties.put("file.separator", "/");
            this.fProperties.put("path.separator", ":");
            this.fProperties.put("line.separator", "\n");
            this.fProperties.put("user.home", this.getPwd());
            try {
                IRemoteExecutionManager exeMgr = this.createExecutionManager();
                if (exeMgr != null) {
                    String osVersion;
                    String osArch;
                    String osName = exeMgr.getExecutionTools().executeWithOutput("uname").trim();
                    if (osName.equalsIgnoreCase("Linux")) {
                        osArch = exeMgr.getExecutionTools().executeWithOutput("uname -m").trim();
                        osVersion = exeMgr.getExecutionTools().executeWithOutput("uname -r").trim();
                    } else if (osName.equalsIgnoreCase("Darwin")) {
                        String opt;
                        osName = exeMgr.getExecutionTools().executeWithOutput("sw_vers -productName").trim();
                        osVersion = exeMgr.getExecutionTools().executeWithOutput("sw_vers -productVersion").trim();
                        osArch = exeMgr.getExecutionTools().executeWithOutput("uname -m").trim();
                        if (osArch.equalsIgnoreCase("i386") && (opt = exeMgr.getExecutionTools().executeWithOutput("sysctl -n hw.optional.x86_64").trim()).equals("1")) {
                            osArch = "x86_64";
                        }
                    } else if (osName.equalsIgnoreCase("AIX")) {
                        osArch = exeMgr.getExecutionTools().executeWithOutput("uname -p").trim();
                        osVersion = exeMgr.getExecutionTools().executeWithOutput("oslevel").trim();
                        if (osArch.equalsIgnoreCase("powerpc")) {
                            osArch = "ppc";
                            String opt = exeMgr.getExecutionTools().executeWithOutput("prtconf -k").trim();
                            if (opt.indexOf("64-bit") > 0) {
                                osArch = String.valueOf(osArch) + "64";
                            }
                        }
                    } else {
                        osVersion = "unknown";
                        osArch = "unknown";
                    }
                    this.fProperties.put("os.name", osName);
                    this.fProperties.put("os.version", osVersion);
                    this.fProperties.put("os.arch", osArch);
                }
            }
            catch (Exception exception) {}
        }
    }

    public void open(IProgressMonitor monitor) throws RemoteConnectionException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (!this.isOpen()) {
            progress.beginTask(Messages.RemoteToolsConnection_open, 2);
            try {
                this.fTargetControl.create((IProgressMonitor)progress.newChild(1));
            }
            catch (CoreException e) {
                throw new RemoteConnectionException(e.getMessage());
            }
        }
    }

    public void open(IUserAuthenticator authenticator, IProgressMonitor monitor) throws RemoteConnectionException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (!this.isOpen()) {
            progress.beginTask(Messages.RemoteToolsConnection_open, 2);
            try {
                this.fTargetControl.create((IProgressMonitor)progress.newChild(1));
            }
            catch (CoreException e) {
                throw new RemoteConnectionException(e.getMessage());
            }
        }
    }

    public void removeConnectionChangeListener(IRemoteConnectionChangeListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public void removeLocalPortForwarding(int port) throws RemoteConnectionException {
        if (!this.isOpen()) {
            throw new RemoteConnectionException(Messages.RemoteToolsConnection_connectionNotOpen);
        }
        Integer portToRemove = port;
        IRemoteTunnel tunnel = this.fTunnels.get(portToRemove);
        if (tunnel != null) {
            try {
                this.fTargetControl.getExecutionManager().releaseTunnel(tunnel);
                this.fTunnels.remove(portToRemove);
            }
            catch (Exception e) {
                throw new RemoteConnectionException(e.getMessage());
            }
        }
    }

    public void removeRemotePortForwarding(int port) throws RemoteConnectionException {
        if (!this.isOpen()) {
            throw new RemoteConnectionException(Messages.RemoteToolsConnection_connectionNotOpen);
        }
        try {
            IRemotePortForwarding portForwarding = this.fTargetControl.getExecutionManager().getPortForwardingTools().getRemotePortForwarding(port);
            this.fTargetControl.getExecutionManager().getPortForwardingTools().releaseForwarding((IPortForwarding)portForwarding);
        }
        catch (Exception e) {
            throw new RemoteConnectionException(e.getMessage());
        }
    }

    public void setName(String name) {
        this.fTargetElement.setName(name);
        this.fireConnectionChangeEvent(8);
    }

    public void setWorkingDirectory(String path) {
        if (new Path(path).isAbsolute()) {
            this.fWorkingDir = path;
        }
    }

    public boolean supportsTCPPortForwarding() {
        return true;
    }

    public String toString() {
        String str = String.valueOf(this.getName()) + " [" + this.getUsername() + "@" + this.getAddress();
        if (this.getPort() >= 0) {
            str = String.valueOf(str) + ":" + this.getPort();
        }
        return String.valueOf(str) + "]";
    }
}

