/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.remotetools.ui;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ptp.internal.remote.remotetools.core.RemoteToolsConnectionManager;
import org.eclipse.ptp.internal.remote.remotetools.core.RemoteToolsConnectionWorkingCopy;
import org.eclipse.ptp.internal.remote.remotetools.core.RemoteToolsServices;
import org.eclipse.ptp.internal.remote.remotetools.ui.RemoteToolsAdapterUIPlugin;
import org.eclipse.ptp.remotetools.environment.control.ITargetConfig;
import org.eclipse.ptp.remotetools.environment.core.ITargetElement;
import org.eclipse.ptp.remotetools.environment.core.TargetElement;
import org.eclipse.ptp.remotetools.environment.wizard.EnvironmentWizard;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.ui.AbstractRemoteUIConnectionManager;
import org.eclipse.remote.ui.IRemoteUIConnectionWizard;
import org.eclipse.swt.widgets.Shell;

public class RemoteToolsUIConnectionManager
extends AbstractRemoteUIConnectionManager {
    private final RemoteToolsConnectionManager connMgr;

    public RemoteToolsUIConnectionManager(RemoteToolsServices services) {
        this.connMgr = (RemoteToolsConnectionManager)services.getConnectionManager();
    }

    public IRemoteUIConnectionWizard getConnectionWizard(final Shell shell) {
        ITargetConfig config;
        TargetElement element = this.connMgr.newTargetElement("new");
        try {
            config = element.getControl().getConfig();
        }
        catch (CoreException coreException) {
            return null;
        }
        return new IRemoteUIConnectionWizard(){
            private String fName;
            private RemoteToolsConnectionWorkingCopy fConnection;

            public IRemoteConnectionWorkingCopy open() {
                RemoteToolsConnectionWorkingCopy conn;
                if (this.fConnection == null) {
                    try {
                        conn = (RemoteToolsConnectionWorkingCopy)RemoteToolsUIConnectionManager.this.connMgr.newConnection(this.fName);
                        for (String key : config.getAttributes().getAttributesAsMap().keySet()) {
                            conn.setAttribute(key, config.getAttributes().getString(key));
                        }
                    }
                    catch (RemoteConnectionException e) {
                        RemoteToolsAdapterUIPlugin.log(e);
                        return null;
                    }
                } else {
                    conn = this.fConnection;
                }
                EnvironmentWizard wizard = new EnvironmentWizard((ITargetElement)conn.getTargetElement());
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                dialog.create();
                dialog.setBlockOnOpen(true);
                if (dialog.open() == 0) {
                    conn.setName(wizard.getName());
                    return conn;
                }
                return null;
            }

            public void setInvalidConnectionNames(Set<String> names) {
            }

            public void setConnectionName(String name) {
                this.fName = name;
            }

            public void setConnection(IRemoteConnectionWorkingCopy connection) {
                if (connection instanceof RemoteToolsConnectionWorkingCopy) {
                    this.fConnection = (RemoteToolsConnectionWorkingCopy)connection;
                }
            }
        };
    }
}

