/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.completion.rcp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.codeassist.InternalCompletionContext;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnMemberAccess;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.Region;
import org.eclipse.recommenders.completion.rcp.CompletionContextFunctions;
import org.eclipse.recommenders.completion.rcp.CompletionContextKey;
import org.eclipse.recommenders.completion.rcp.ICompletionContextFunction;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.rcp.IAstProvider;
import org.eclipse.recommenders.rcp.utils.CompilerBindings;
import org.eclipse.recommenders.rcp.utils.JdtUtils;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.VmTypeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecommendersCompletionContext
implements IRecommendersCompletionContext {
    private static final Logger LOG = LoggerFactory.getLogger(RecommendersCompletionContext.class);
    private Map<CompletionContextKey, Object> data = Maps.newHashMap();
    private Map<CompletionContextKey, ICompletionContextFunction> functions;

    @VisibleForTesting
    public static Set<ITypeName> createTypeNamesFromSignatures(char[][] sigs) {
        if (sigs == null) {
            return Collections.emptySet();
        }
        if (sigs.length < 1) {
            return Collections.emptySet();
        }
        HashSet res = Sets.newHashSet();
        char[][] cArray = sigs;
        int n = sigs.length;
        int n2 = 0;
        while (n2 < n) {
            char[] sig = cArray[n2];
            try {
                String descriptor = new String(sig).replace('.', '/');
                descriptor = StringUtils.substringBeforeLast((String)descriptor, (String)";");
                res.add(VmTypeName.get((String)descriptor));
            }
            catch (Exception e) {
                LOG.error("Couldn't parse type name: '{}'", (Object)String.valueOf(sig), (Object)e);
            }
            ++n2;
        }
        return res;
    }

    public RecommendersCompletionContext(JavaContentAssistInvocationContext jdtContext, IAstProvider astProvider) {
        this(jdtContext, astProvider, CompletionContextFunctions.defaultFunctions());
    }

    @Inject
    public RecommendersCompletionContext(JavaContentAssistInvocationContext jdtContext, IAstProvider astProvider, Map<CompletionContextKey, ICompletionContextFunction> functions) {
        this.set(CompletionContextKey.JAVA_CONTENTASSIST_CONTEXT, jdtContext);
        this.set(CompletionContextKey.AST_PROVIDER, astProvider);
        this.functions = functions;
    }

    @Override
    public Optional<CompilationUnit> getAST() {
        IAstProvider astProvider = this.get(CompletionContextKey.AST_PROVIDER, null);
        CompilationUnit ast = astProvider != null ? astProvider.get(this.getCompilationUnit()) : null;
        return Optional.fromNullable((Object)ast);
    }

    @Override
    public ICompilationUnit getCompilationUnit() {
        return this.getJavaContext().getCompilationUnit();
    }

    @Override
    public Optional<ASTNode> getCompletionNode() {
        InternalCompletionContext ctx = this.doGetCoreContext();
        ASTNode res = ctx != null ? ctx.getCompletionNode() : null;
        return Optional.fromNullable((Object)res);
    }

    @Override
    public Optional<ASTNode> getCompletionNodeParent() {
        InternalCompletionContext ctx = this.doGetCoreContext();
        ASTNode res = ctx != null ? ctx.getCompletionNodeParent() : null;
        return Optional.fromNullable((Object)res);
    }

    public Optional<InternalCompletionContext> getCoreContext() {
        return Optional.fromNullable((Object)this.doGetCoreContext());
    }

    private InternalCompletionContext doGetCoreContext() {
        return this.get(CompletionContextKey.INTERNAL_COMPLETIONCONTEXT, null);
    }

    @Override
    public Optional<IJavaElement> getEnclosingElement() {
        IJavaElement enclosing = this.get(CompletionContextKey.ENCLOSING_ELEMENT, null);
        return Optional.fromNullable((Object)enclosing);
    }

    @Override
    public Optional<IMethod> getEnclosingMethod() {
        IMethod enclosing = this.get(CompletionContextKey.ENCLOSING_METHOD, null);
        return Optional.fromNullable((Object)enclosing);
    }

    @Override
    public Optional<IType> getEnclosingType() {
        IType enclosing = this.get(CompletionContextKey.ENCLOSING_TYPE, null);
        return Optional.fromNullable((Object)enclosing);
    }

    @Override
    public Optional<IType> getExpectedType() {
        IType res = this.get(CompletionContextKey.EXPECTED_TYPE, null);
        return Optional.fromNullable((Object)res);
    }

    @Override
    public Set<ITypeName> getExpectedTypeNames() {
        Set res = this.get(CompletionContextKey.EXPECTED_TYPENAMES, null);
        return res == null ? Sets.newHashSet() : res;
    }

    @Override
    public Optional<String> getExpectedTypeSignature() {
        InternalCompletionContext coreContext = this.doGetCoreContext();
        if (coreContext == null) {
            return Optional.absent();
        }
        char[][] keys = coreContext.getExpectedTypesSignatures();
        if (keys == null) {
            return Optional.absent();
        }
        if (keys.length < 1) {
            return Optional.absent();
        }
        String res = new String(keys[0]);
        return Optional.of((Object)res);
    }

    @Override
    public Optional<IType> getClosestEnclosingType() {
        IJavaElement enclosing = this.get(CompletionContextKey.ENCLOSING_ELEMENT, null);
        if (enclosing == null) {
            return Optional.absent();
        }
        if (enclosing instanceof IType) {
            return Optional.of((Object)((IType)enclosing));
        }
        IType type = (IType)enclosing.getAncestor(7);
        return Optional.fromNullable((Object)type);
    }

    @Override
    public int getInvocationOffset() {
        return this.getJavaContext().getInvocationOffset();
    }

    @Override
    public JavaContentAssistInvocationContext getJavaContext() {
        return this.get(CompletionContextKey.JAVA_CONTENTASSIST_CONTEXT, null);
    }

    @Override
    public Optional<IMethodName> getMethodDef() {
        ASTNode node = (ASTNode)this.getCompletionNode().orNull();
        if (node == null) {
            return Optional.absent();
        }
        if (node instanceof CompletionOnMemberAccess) {
            CompletionOnMemberAccess n = (CompletionOnMemberAccess)Checks.cast((Object)node);
            if (n.receiver instanceof MessageSend) {
                MessageSend receiver = (MessageSend)n.receiver;
                MethodBinding binding = receiver.binding;
                return CompilerBindings.toMethodName((MethodBinding)binding);
            }
            if (n.receiver instanceof AllocationExpression) {
                AllocationExpression receiver = (AllocationExpression)n.receiver;
                MethodBinding binding = receiver.binding;
                return CompilerBindings.toMethodName((MethodBinding)binding);
            }
        }
        return Optional.absent();
    }

    @Override
    public String getPrefix() {
        return this.get(CompletionContextKey.COMPLETION_PREFIX, "");
    }

    @Override
    public IJavaProject getProject() {
        return this.getJavaContext().getProject();
    }

    @Override
    public Map<IJavaCompletionProposal, CompletionProposal> getProposals() {
        return this.get(CompletionContextKey.JAVA_PROPOSALS, Maps.newHashMap());
    }

    @Override
    public String getReceiverName() {
        return this.get(CompletionContextKey.RECEIVER_NAME, "");
    }

    @Override
    public Optional<IType> getReceiverType() {
        TypeBinding b = this.get(CompletionContextKey.RECEIVER_TYPEBINDING, null);
        if (b == null || b instanceof MissingTypeBinding) {
            return Optional.absent();
        }
        return JdtUtils.createUnresolvedType((TypeBinding)b.erasure());
    }

    @Override
    public Optional<String> getReceiverTypeSignature() {
        TypeBinding b = this.get(CompletionContextKey.RECEIVER_TYPEBINDING, null);
        if (b == null) {
            return Optional.absent();
        }
        String res = new String(b.signature());
        return Optional.of((Object)res);
    }

    @Override
    public Region getReplacementRange() {
        int offset = this.getInvocationOffset();
        int length = this.getPrefix().length();
        return new Region(offset, length);
    }

    @Override
    public List<IField> getVisibleFields() {
        return this.get(CompletionContextKey.VISIBLE_FIELDS, Collections.emptyList());
    }

    @Override
    public List<ILocalVariable> getVisibleLocals() {
        return this.get(CompletionContextKey.VISIBLE_LOCALS, Collections.emptyList());
    }

    @Override
    public List<IMethod> getVisibleMethods() {
        return this.get(CompletionContextKey.VISIBLE_METHODS, Collections.emptyList());
    }

    @Override
    public boolean hasEnclosingElement() {
        return this.getEnclosingElement().isPresent();
    }

    @Override
    public boolean isCompletionInMethodBody() {
        return this.getEnclosingMethod().isPresent();
    }

    @Override
    public boolean isCompletionInTypeBody() {
        return this.getEnclosingType().isPresent();
    }

    @Override
    public <T> void set(CompletionContextKey<T> key, T value) {
        Checks.ensureIsNotNull(key);
        this.data.put(key, value);
    }

    @Override
    public ImmutableMap<CompletionContextKey, Object> values() {
        return ImmutableMap.copyOf(this.data);
    }

    @Override
    public <T> Optional<T> get(CompletionContextKey<T> key) {
        if (this.data.containsKey(key)) {
            return Optional.fromNullable((Object)this.data.get(key));
        }
        ICompletionContextFunction function = this.functions.get(key);
        if (function != null) {
            T res = function.compute(this, key);
            return Optional.fromNullable(res);
        }
        return Optional.absent();
    }

    @Override
    public <T> T get(CompletionContextKey<T> key, T defaultValue) {
        Object res = this.get(key).orNull();
        return (T)(res != null ? res : defaultValue);
    }
}

