/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jayes.util;

import java.util.Map;
import org.eclipse.recommenders.jayes.BayesNode;
import org.eclipse.recommenders.jayes.factor.AbstractFactor;
import org.eclipse.recommenders.jayes.factor.Cut;

public final class BayesNodeUtil {
    private BayesNodeUtil() {
        throw new IllegalStateException("Not meant to be instantiated");
    }

    public static double[] getSubCpt(BayesNode node, Map<BayesNode, String> evidence) {
        AbstractFactor factor = node.getFactor();
        for (BayesNode p : node.getParents()) {
            if (evidence.containsKey(p)) {
                factor.select(p.getId(), p.getOutcomeIndex(evidence.get(p)));
                continue;
            }
            throw new IllegalArgumentException("evidence does not cover all parents of node");
        }
        Cut cut = new Cut(factor);
        cut.initialize();
        if (cut.getSubCut() != null || cut.getStepSize() != 1 || cut.getEnd() - cut.getStart() != node.getOutcomeCount()) {
            throw new AssertionError((Object)"Unexpected factor structure: node's dimension is not the lowest");
        }
        double[] subCpt = new double[node.getOutcomeCount()];
        int i = 0;
        while (i < node.getOutcomeCount()) {
            subCpt[i] = factor.getValue(cut.getStart() + i * cut.getStepSize());
            ++i;
        }
        factor.resetSelections();
        return subCpt;
    }
}

