/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.overrides;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.math.stat.StatUtils;
import org.eclipse.recommenders.jayes.BayesNet;
import org.eclipse.recommenders.jayes.BayesNode;
import org.eclipse.recommenders.overrides.IOverrideModel;
import org.eclipse.recommenders.overrides.JayesOverrideModel;
import org.eclipse.recommenders.overrides.OverrideObservation;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;

public class JayesOverrideModelBuilder {
    private static final double MIN = 1.0E-4;
    private static final double MAX = 0.9999;
    private final ITypeName typeName;
    private final BayesNet network;
    private final Collection<OverrideObservation> overriddenMethods;
    private int totalNumberOfSubtypesFound;
    private BayesNode patternNode;
    private LinkedList<BayesNode> methodNodes;

    public JayesOverrideModelBuilder(ITypeName typeName, Collection<OverrideObservation> overriddenMethods) {
        this.typeName = typeName;
        this.overriddenMethods = overriddenMethods;
        Checks.ensureIsGreaterOrEqualTo((double)overriddenMethods.size(), (double)1.0, (String)"at least one observation is required");
        this.computeTotalNumberOfSubtypes();
        this.network = new BayesNet();
    }

    private void computeTotalNumberOfSubtypes() {
        for (OverrideObservation usage : this.overriddenMethods) {
            this.totalNumberOfSubtypesFound += usage.frequency;
        }
    }

    public IOverrideModel build() {
        this.createPatternNodeInNetwork();
        this.createMethodNodes();
        return new JayesOverrideModel(this.typeName, this.network, this.patternNode, this.methodNodes);
    }

    private void createPatternNodeInNetwork() {
        this.patternNode = this.network.createNode("patternNode");
        this.patternNode.addOutcome("none");
        double[] def = new double[1 + this.overriddenMethods.size()];
        def[0] = 1.0E-4;
        int i = 0;
        for (OverrideObservation obs : this.overriddenMethods) {
            double priorPatternProbability;
            String name = "observation_" + ++i;
            this.patternNode.addOutcome(name);
            def[i] = priorPatternProbability = (double)obs.frequency / (double)this.totalNumberOfSubtypesFound;
        }
        this.scaleMaximalValue(def);
        this.patternNode.setProbabilities(def);
    }

    private void scaleMaximalValue(double[] subDefinition) {
        double diff = StatUtils.sum((double[])subDefinition) - 1.0;
        double max = StatUtils.max((double[])subDefinition);
        int indexOf = ArrayUtils.indexOf((double[])subDefinition, (double)max);
        subDefinition[indexOf] = subDefinition[indexOf] - diff;
    }

    private void createMethodNodes() {
        TreeSet<IMethodName> methods = this.collectInvokedMethodsFromPatterns();
        this.methodNodes = Lists.newLinkedList();
        for (IMethodName ref : methods) {
            BayesNode methodNode = this.network.createNode(ref.getIdentifier());
            methodNode.setParents((List)Lists.newArrayList((Object[])new BayesNode[]{this.patternNode}));
            methodNode.addOutcome("true");
            methodNode.addOutcome("false");
            methodNode.setProbabilities(this.createMethodNodeDefinition(ref));
            this.methodNodes.add(methodNode);
        }
    }

    private double[] createMethodNodeDefinition(IMethodName ref) {
        double[] definition = new double[2 + 2 * this.overriddenMethods.size()];
        definition[0] = 0.0;
        definition[1] = 1.0;
        int i = 2;
        for (OverrideObservation pattern : this.overriddenMethods) {
            boolean overridesMethod = pattern.overriddenMethods.contains(ref);
            if (overridesMethod) {
                definition[i++] = 0.9999;
                definition[i++] = 1.0E-4;
                continue;
            }
            definition[i++] = 1.0E-4;
            definition[i++] = 0.9999;
        }
        return definition;
    }

    private TreeSet<IMethodName> collectInvokedMethodsFromPatterns() {
        TreeSet<IMethodName> methods = new TreeSet<IMethodName>();
        for (OverrideObservation observation : this.overriddenMethods) {
            methods.addAll(observation.overriddenMethods);
        }
        return methods;
    }
}

