/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp;

import java.text.MessageFormat;
import javax.inject.Inject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.recommenders.internal.rcp.Messages;
import org.eclipse.recommenders.rcp.SharedImages;
import org.eclipse.recommenders.rcp.utils.BrowserUtils;
import org.eclipse.recommenders.rcp.utils.Dialogs;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class RootPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final SharedImages images;

    @Inject
    public RootPreferencePage(SharedImages images) {
        this.images = images;
    }

    public void init(IWorkbench workbench) {
        this.setDescription(Messages.PREFPAGE_DESCRIPTION_EMPTY);
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().applyTo((Control)composite);
        GridLayoutFactory.swtDefaults().margins(0, 5).applyTo(composite);
        Group group = new Group(composite, 0);
        group.setText("Useful links");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)group);
        BrowserUtils.addOpenBrowserAction(this.createLink((Composite)group, SharedImages.Images.OBJ_HOMEPAGE, Messages.PREFPAGE_LINK_HOMEPAGE, "http://www.eclipse.org/recommenders/"));
        BrowserUtils.addOpenBrowserAction(this.createLink((Composite)group, SharedImages.Images.OBJ_CONTAINER, Messages.PREFPAGE_LINK_MANUAL, "http://www.eclipse.org/recommenders/manual/"));
        BrowserUtils.addOpenBrowserAction(this.createLink((Composite)group, SharedImages.Images.OBJ_FAVORITE_STAR, Messages.PREFPAGE_LINK_FAVORITE, "http://marketplace.eclipse.org/content/eclipse-code-recommenders"));
        BrowserUtils.addOpenBrowserAction(this.createLink((Composite)group, SharedImages.Images.OBJ_BIRD_BLUE, Messages.PREFPAGE_LINK_TWITTER, "http://twitter.com/recommenders"));
        this.addOpenExtensionDiscoveryDialogAction(this.createLink((Composite)group, SharedImages.Images.OBJ_LIGHTBULB, Messages.PREFPAGE_LINK_EXTENSIONS, ""));
        return parent;
    }

    private Link createLink(Composite content, SharedImages.Images icon, String urlLabel, String url) {
        Label label = new Label(content, 1);
        label.setImage(this.images.getImage(icon));
        Link link = new Link(content, 1);
        link.setText(MessageFormat.format(urlLabel, url));
        return link;
    }

    private void addOpenExtensionDiscoveryDialogAction(Link link) {
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Dialogs.newExtensionsDiscoveryDialog().open();
            }
        });
    }
}

