/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp.news;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.recommenders.internal.rcp.LogMessages;
import org.eclipse.recommenders.internal.rcp.news.NewsNotificationPopup;
import org.eclipse.recommenders.internal.rcp.news.RssParser;
import org.eclipse.recommenders.net.Proxies;
import org.eclipse.recommenders.rcp.utils.Shells;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.Pair;
import org.eclipse.recommenders.utils.Urls;

public class CheckForProjectNewsJob
extends Job {
    static final String NEWS_ENABLED = "news-enabled";
    static final String NEWS_LAST_CHECK = "news-last-check";
    private URI feed = Urls.toUri((URL)Urls.toUrl((String)"http://www.codetrails.com/blog/feed/planet-eclipse"));
    private IEclipsePreferences prefs;

    static IEclipsePreferences getPreferences() {
        return InstanceScope.INSTANCE.getNode("org.eclipse.recommenders.rcp");
    }

    public CheckForProjectNewsJob() {
        super("Loading Project Newsfeed...");
        this.setSystem(true);
        this.prefs = CheckForProjectNewsJob.getPreferences();
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.doRun();
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.LOG_WARNING_EXCEPTION_PARSING_NEWS_FEED, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public boolean shouldRun() {
        boolean enabled = this.prefs.getBoolean(NEWS_ENABLED, true);
        if (!enabled) {
            return false;
        }
        long time = this.prefs.getLong(NEWS_LAST_CHECK, 0L);
        Date last = new Date(time);
        Date now = new Date();
        Date pause = DateUtils.addDays((Date)last, (int)4);
        return !pause.after(now);
    }

    private void doRun() throws IOException {
        String string = (String)this.download().orNull();
        if (string == null) {
            return;
        }
        Date last = this.getLastRun();
        List<Pair<String, URL>> entries = RssParser.getEntries(string, last);
        this.saveLastRun(new Date());
        if (entries.isEmpty()) {
            return;
        }
        Pair<String, URL> latest = entries.get(0);
        final String link = MessageFormat.format("The Code Recommenders project has published a new blog post: {0}. <a href=\"{1}\">Read more...</a>", latest.getFirst(), latest.getSecond());
        Shells.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                new NewsNotificationPopup(link).open();
            }
        });
    }

    private void saveLastRun(Date last) {
        this.prefs.putLong(NEWS_LAST_CHECK, last.getTime());
    }

    private Date getLastRun() {
        long time = this.prefs.getLong(NEWS_LAST_CHECK, System.currentTimeMillis());
        Date last = new Date(time);
        return last;
    }

    private Optional<String> download() throws IOException {
        Executor executor = Executor.newInstance();
        Request request = Request.Get((URI)this.feed);
        Response response = Proxies.proxy((Executor)executor, (URI)this.feed).execute(request);
        HttpResponse httpResponse = response.returnResponse();
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        if (statusCode >= 400) {
            return Optional.absent();
        }
        HttpEntity entity = httpResponse.getEntity();
        return Optional.of((Object)IOUtils.toString((InputStream)entity.getContent(), (String)Charsets.UTF_8.name()));
    }
}

