/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import org.eclipse.jdt.internal.ui.text.java.RelevanceSorter;
import org.eclipse.jdt.ui.text.java.AbstractProposalSorter;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalSorter;
import org.eclipse.recommenders.internal.snipmatch.rcp.RepositoryProposal;
import org.eclipse.recommenders.internal.snipmatch.rcp.SnippetProposal;

public class ProposalSorter
extends AbstractProposalSorter {
    private static final Comparator<Integer> LOWER_PRIORITY_FIRST = Ordering.natural();
    private static final ICompletionProposalSorter FALLBACK_SORTER = new RelevanceSorter();

    public int compare(ICompletionProposal lhs, ICompletionProposal rhs) {
        if (lhs instanceof SnippetProposal && rhs instanceof SnippetProposal) {
            SnippetProposal lhsSnippet = (SnippetProposal)lhs;
            SnippetProposal rhsSnippet = (SnippetProposal)rhs;
            return ComparisonChain.start().compare(lhsSnippet.getRepositoryRelevance(), rhsSnippet.getRepositoryRelevance()).compare(rhsSnippet.getRelevance(), lhsSnippet.getRelevance()).compare((Comparable)((Object)lhsSnippet.getSnippet().getName()), (Comparable)((Object)rhsSnippet.getSnippet().getName())).result();
        }
        if (lhs instanceof RepositoryProposal && rhs instanceof RepositoryProposal) {
            RepositoryProposal lhsRepository = (RepositoryProposal)lhs;
            RepositoryProposal rhsRepository = (RepositoryProposal)rhs;
            return LOWER_PRIORITY_FIRST.compare(lhsRepository.getRepositoryPriority(), rhsRepository.getRepositoryPriority());
        }
        if (lhs instanceof RepositoryProposal && rhs instanceof SnippetProposal) {
            return this.compareRepositoryWithSnippet((RepositoryProposal)lhs, (SnippetProposal)rhs);
        }
        if (lhs instanceof SnippetProposal && rhs instanceof RepositoryProposal) {
            return -this.compareRepositoryWithSnippet((RepositoryProposal)rhs, (SnippetProposal)lhs);
        }
        return FALLBACK_SORTER.compare(lhs, rhs);
    }

    private int compareRepositoryWithSnippet(RepositoryProposal repository, SnippetProposal snippet) {
        int comparison = LOWER_PRIORITY_FIRST.compare(repository.getRepositoryPriority(), snippet.getRepositoryRelevance());
        return comparison != 0 ? comparison : -1;
    }
}

