/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import java.io.Closeable;
import java.io.IOException;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.eclipse.recommenders.internal.snipmatch.rcp.SnipmatchRcpPreferences;
import org.eclipse.recommenders.rcp.IRcpService;
import org.eclipse.recommenders.snipmatch.ISnippetRepository;
import org.eclipse.recommenders.snipmatch.model.SnippetRepositoryConfiguration;
import org.eclipse.recommenders.snipmatch.rcp.model.SnippetRepositoryConfigurations;
import org.eclipse.recommenders.utils.Openable;

public class Repositories
implements IRcpService,
Openable,
Closeable {
    private final SnippetRepositoryConfigurations configurations;
    private final SnipmatchRcpPreferences prefs;
    private Set<ISnippetRepository> repositories = Sets.newHashSet();

    @Inject
    public Repositories(EventBus bus, SnippetRepositoryConfigurations configurations, SnipmatchRcpPreferences prefs) {
        bus.register((Object)this);
        this.prefs = prefs;
        this.configurations = configurations;
    }

    @PostConstruct
    public void open() throws IOException {
        this.repositories.clear();
        for (SnippetRepositoryConfiguration config : this.configurations.getRepos()) {
            if (!this.prefs.isRepositoryEnabled(config)) continue;
            ISnippetRepository repo = config.createRepositoryInstance();
            repo.open();
            this.repositories.add(repo);
        }
    }

    @Override
    @PreDestroy
    public void close() throws IOException {
        for (ISnippetRepository repo : this.repositories) {
            repo.close();
        }
        this.repositories.clear();
    }

    public Set<ISnippetRepository> getRepositories() {
        return this.repositories;
    }

    public Optional<ISnippetRepository> getRepository(String id) {
        for (ISnippetRepository repo : this.repositories) {
            if (!repo.getId().equals(id)) continue;
            return Optional.of((Object)repo);
        }
        return Optional.absent();
    }

    @Subscribe
    public void onEvent(SnippetRepositoryConfigurationChangedEvent e) throws IOException {
        this.close();
        this.open();
    }

    public static class SnippetRepositoryConfigurationChangedEvent {
    }
}

