/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp.editors;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.databinding.property.value.SimpleValueProperty;
import org.eclipse.core.internal.databinding.property.value.SelfValueProperty;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.recommenders.injection.InjectionService;
import org.eclipse.recommenders.internal.models.rcp.ProjectCoordinateSelectionDialog;
import org.eclipse.recommenders.internal.snipmatch.rcp.Messages;
import org.eclipse.recommenders.internal.snipmatch.rcp.SnippetEditorDiscoveryUtils;
import org.eclipse.recommenders.internal.snipmatch.rcp.editors.EditorUtils;
import org.eclipse.recommenders.models.ProjectCoordinate;
import org.eclipse.recommenders.rcp.SharedImages;
import org.eclipse.recommenders.rcp.utils.BrowserUtils;
import org.eclipse.recommenders.rcp.utils.ObjectToBooleanConverter;
import org.eclipse.recommenders.rcp.utils.Selections;
import org.eclipse.recommenders.snipmatch.ISnippet;
import org.eclipse.recommenders.snipmatch.Location;
import org.eclipse.recommenders.snipmatch.Snippet;
import org.eclipse.recommenders.snipmatch.rcp.SnippetEditorInput;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class SnippetMetadataPage
extends FormPage {
    private static final Location[] SNIPMATCH_LOCATIONS = new Location[]{Location.FILE, Location.JAVA, Location.JAVA_STATEMENTS, Location.JAVA_TYPE_MEMBERS, Location.JAVADOC};
    public static final String TEXT_SNIPPETNAME = "org.eclipse.recommenders.snipmatch.rcp.snippetmetadatapage.snippetname";
    private ISnippet snippet;
    private AbstractFormPart contentsPart;
    private Text txtName;
    private Text txtDescription;
    private ComboViewer comboLocation;
    private Text txtUuid;
    private ListViewer listViewerDependencies;
    private ListViewer listViewerExtraSearchTerms;
    private ListViewer listViewerTags;
    private Composite btnContainerDependencies;
    private Composite btnContainerExtraSearchTerms;
    private Composite btnContainerTags;
    private Button btnAddDependency;
    private Button btnAddExtraSearchTerm;
    private Button btnAddTag;
    private Button btnRemoveDependency;
    private Button btnRemoveExtraSearchTerm;
    private Button btnRemoveTag;
    private IObservableSet ppDependencies;
    private IObservableList ppExtraSearchTerms;
    private IObservableList ppTags;
    private DataBindingContext context;
    private final Image decorationImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();

    public SnippetMetadataPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        this.createHeader(form);
        Composite body = form.getBody();
        toolkit.decorateFormHeading(form.getForm());
        toolkit.paintBordersFor(body);
        managedForm.getForm().getBody().setLayout((Layout)new GridLayout(3, false));
        this.contentsPart = new AbstractFormPart(){

            public void initialize(IManagedForm managedForm) {
                super.initialize(managedForm);
                Label lblName = managedForm.getToolkit().createLabel(managedForm.getForm().getBody(), Messages.EDITOR_LABEL_SNIPPET_NAME, 0);
                lblName.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
                int horizontalIndent = ((SnippetMetadataPage)SnippetMetadataPage.this).decorationImage.getBounds().width + 2;
                SnippetMetadataPage.this.txtName = managedForm.getToolkit().createText(managedForm.getForm().getBody(), SnippetMetadataPage.this.snippet.getName(), 0);
                SnippetMetadataPage.this.txtName.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).indent(horizontalIndent, 0).create());
                SnippetMetadataPage.this.txtName.setData("org.eclipse.swtbot.widget.key", (Object)SnippetMetadataPage.TEXT_SNIPPETNAME);
                SnippetMetadataPage.this.txtName.setMessage(Messages.EDITOR_TEXT_MESSAGE_SNIPPET_NAME);
                final ControlDecoration nameDecoration = new ControlDecoration((Control)SnippetMetadataPage.this.txtName, 16384);
                nameDecoration.setDescriptionText(Messages.ERROR_SNIPPET_NAME_CANNOT_BE_EMPTY);
                nameDecoration.setImage(SnippetMetadataPage.this.decorationImage);
                nameDecoration.setMarginWidth(1);
                SnippetMetadataPage.this.txtName.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent arg0) {
                        if (Strings.isNullOrEmpty((String)SnippetMetadataPage.this.txtName.getText())) {
                            nameDecoration.show();
                        } else {
                            nameDecoration.hide();
                        }
                    }
                });
                Label lblDescription = managedForm.getToolkit().createLabel(managedForm.getForm().getBody(), Messages.EDITOR_LABEL_SNIPPET_DESCRIPTION, 0);
                lblDescription.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
                SnippetMetadataPage.this.txtDescription = managedForm.getToolkit().createText(managedForm.getForm().getBody(), SnippetMetadataPage.this.snippet.getDescription(), 0);
                SnippetMetadataPage.this.txtDescription.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).indent(horizontalIndent, 0).create());
                SnippetMetadataPage.this.txtDescription.setMessage(Messages.EDITOR_TEXT_MESSAGE_SNIPPET_DESCRIPTION);
                Label lblLocation = managedForm.getToolkit().createLabel(managedForm.getForm().getBody(), Messages.EDITOR_LABEL_SNIPPET_LOCATION, 0);
                lblLocation.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
                SnippetMetadataPage.this.comboLocation = new ComboViewer(managedForm.getForm().getBody(), 12);
                managedForm.getToolkit().adapt((Control)SnippetMetadataPage.this.comboLocation.getCombo(), true, true);
                SnippetMetadataPage.this.comboLocation.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
                SnippetMetadataPage.this.comboLocation.setInput((Object)SNIPMATCH_LOCATIONS);
                SnippetMetadataPage.this.comboLocation.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                    public String getText(Object element) {
                        if (element instanceof Location) {
                            Location location = (Location)element;
                            switch (location) {
                                case FILE: {
                                    return Messages.SNIPMATCH_LOCATION_FILE;
                                }
                                case JAVA: {
                                    return Messages.SNIPMATCH_LOCATION_JAVA;
                                }
                                case JAVA_STATEMENTS: {
                                    return Messages.SNIPMATCH_LOCATION_JAVA_STATEMENTS;
                                }
                                case JAVA_TYPE_MEMBERS: {
                                    return Messages.SNIPMATCH_LOCATION_JAVA_MEMBERS;
                                }
                                case JAVADOC: {
                                    return Messages.SNIPMATCH_LOCATION_JAVADOC;
                                }
                            }
                        }
                        return super.getText(element);
                    }
                });
                SnippetMetadataPage.this.comboLocation.getCombo().setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).indent(horizontalIndent, 0).create());
                final ControlDecoration locationErrorDecoration = new ControlDecoration((Control)SnippetMetadataPage.this.comboLocation.getCombo(), 16384);
                locationErrorDecoration.setDescriptionText(String.valueOf(Messages.ERROR_SNIPPET_LOCATION_CANNOT_BE_EMPTY) + "\n" + Messages.EDITOR_DESCRIPTION_LOCATION);
                locationErrorDecoration.setImage(SnippetMetadataPage.this.decorationImage);
                locationErrorDecoration.setMarginWidth(1);
                final ControlDecoration locationDescriptionDecoration = new ControlDecoration((Control)SnippetMetadataPage.this.comboLocation.getCombo(), 16384);
                FieldDecoration infoDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION");
                locationDescriptionDecoration.setImage(infoDecoration.getImage());
                locationDescriptionDecoration.setDescriptionText(Messages.EDITOR_DESCRIPTION_LOCATION);
                locationDescriptionDecoration.setMarginWidth(1);
                SnippetMetadataPage.this.comboLocation.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        if (event.getSelection().isEmpty()) {
                            locationErrorDecoration.show();
                            locationDescriptionDecoration.hide();
                        } else {
                            locationErrorDecoration.hide();
                            locationDescriptionDecoration.show();
                        }
                    }
                });
                SnippetMetadataPage.this.comboLocation.setSelection((ISelection)new StructuredSelection((Object)SnippetMetadataPage.this.snippet.getLocation()));
                Label lblExtraSearchTerms = managedForm.getToolkit().createLabel(managedForm.getForm().getBody(), Messages.EDITOR_LABEL_SNIPPETS_EXTRA_SEARCH_TERMS, 0);
                lblExtraSearchTerms.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
                SnippetMetadataPage.this.listViewerExtraSearchTerms = new ListViewer(managedForm.getForm().getBody(), 2560);
                List lstExtraSearchTerm = SnippetMetadataPage.this.listViewerExtraSearchTerms.getList();
                lstExtraSearchTerm.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).indent(horizontalIndent, 0).create());
                ControlDecoration extraSearchTermsDescriptionDecoration = new ControlDecoration((Control)SnippetMetadataPage.this.listViewerExtraSearchTerms.getList(), 16512);
                extraSearchTermsDescriptionDecoration.setImage(infoDecoration.getImage());
                extraSearchTermsDescriptionDecoration.setDescriptionText(Messages.EDITOR_DESCRIPTION_EXTRA_SEARCH_TERMS);
                extraSearchTermsDescriptionDecoration.setMarginWidth(1);
                SnippetMetadataPage.this.btnContainerExtraSearchTerms = managedForm.getToolkit().createComposite(managedForm.getForm().getBody(), 0);
                SnippetMetadataPage.this.btnContainerExtraSearchTerms.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
                managedForm.getToolkit().paintBordersFor(SnippetMetadataPage.this.btnContainerExtraSearchTerms);
                SnippetMetadataPage.this.btnContainerExtraSearchTerms.setLayout((Layout)new GridLayout(1, false));
                SnippetMetadataPage.this.btnAddExtraSearchTerm = managedForm.getToolkit().createButton(SnippetMetadataPage.this.btnContainerExtraSearchTerms, Messages.EDITOR_BUTTON_ADD_EXTRASEARCH_TERM, 0);
                SnippetMetadataPage.this.btnAddExtraSearchTerm.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        SnippetMetadataPage.this.createExtraSearchTermInputDialog(SnippetMetadataPage.this.btnContainerExtraSearchTerms.getShell()).open();
                    }
                });
                SnippetMetadataPage.this.btnAddExtraSearchTerm.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
                SnippetMetadataPage.this.btnRemoveExtraSearchTerm = managedForm.getToolkit().createButton(SnippetMetadataPage.this.btnContainerExtraSearchTerms, Messages.EDITOR_BUTTON_REMOVE_EXTRA_SEARCH_TERM, 0);
                SnippetMetadataPage.this.btnRemoveExtraSearchTerm.setEnabled(false);
                SnippetMetadataPage.this.btnRemoveExtraSearchTerm.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Optional o = Selections.getFirstSelected((Viewer)SnippetMetadataPage.this.listViewerExtraSearchTerms);
                        if (o.isPresent()) {
                            SnippetMetadataPage.this.ppExtraSearchTerms.remove(o.get());
                        }
                    }
                });
                SnippetMetadataPage.this.btnRemoveExtraSearchTerm.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
                Label lblTag = managedForm.getToolkit().createLabel(managedForm.getForm().getBody(), Messages.EDITOR_LABEL_SNIPPETS_TAG, 0);
                lblTag.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
                SnippetMetadataPage.this.listViewerTags = new ListViewer(managedForm.getForm().getBody(), 2560);
                List lstTags = SnippetMetadataPage.this.listViewerTags.getList();
                lstTags.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).indent(horizontalIndent, 0).create());
                ControlDecoration tagsDescriptionDecoration = new ControlDecoration((Control)SnippetMetadataPage.this.listViewerTags.getList(), 16512);
                tagsDescriptionDecoration.setImage(infoDecoration.getImage());
                tagsDescriptionDecoration.setDescriptionText(Messages.EDITOR_DESCRIPTION_TAGS);
                tagsDescriptionDecoration.setMarginWidth(1);
                SnippetMetadataPage.this.btnContainerTags = managedForm.getToolkit().createComposite(managedForm.getForm().getBody(), 0);
                SnippetMetadataPage.this.btnContainerTags.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
                managedForm.getToolkit().paintBordersFor(SnippetMetadataPage.this.btnContainerExtraSearchTerms);
                SnippetMetadataPage.this.btnContainerTags.setLayout((Layout)new GridLayout(1, false));
                SnippetMetadataPage.this.btnAddTag = managedForm.getToolkit().createButton(SnippetMetadataPage.this.btnContainerTags, Messages.EDITOR_BUTTON_ADD_TAGS, 0);
                SnippetMetadataPage.this.btnAddTag.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        SnippetMetadataPage.this.createTagInputDialog(SnippetMetadataPage.this.btnContainerTags.getShell()).open();
                    }
                });
                SnippetMetadataPage.this.btnAddTag.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
                SnippetMetadataPage.this.btnRemoveTag = managedForm.getToolkit().createButton(SnippetMetadataPage.this.btnContainerTags, Messages.EDITOR_BUTTON_REMOVE_TAGS, 0);
                SnippetMetadataPage.this.btnRemoveTag.setEnabled(false);
                SnippetMetadataPage.this.btnRemoveTag.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Optional o = Selections.getFirstSelected((Viewer)SnippetMetadataPage.this.listViewerTags);
                        if (o.isPresent()) {
                            SnippetMetadataPage.this.ppTags.remove(o.get());
                        }
                    }
                });
                SnippetMetadataPage.this.btnRemoveTag.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
                Label lblDependencies = managedForm.getToolkit().createLabel(managedForm.getForm().getBody(), Messages.EDITOR_LABEL_SNIPPET_DEPENENCIES, 0);
                lblDependencies.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
                SnippetMetadataPage.this.listViewerDependencies = new ListViewer(managedForm.getForm().getBody(), 2560);
                List lstDependencies = SnippetMetadataPage.this.listViewerDependencies.getList();
                lstDependencies.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).indent(horizontalIndent, 0).create());
                ControlDecoration dependencyDescriptionDecoration = new ControlDecoration((Control)SnippetMetadataPage.this.listViewerDependencies.getList(), 16512);
                dependencyDescriptionDecoration.setImage(infoDecoration.getImage());
                dependencyDescriptionDecoration.setDescriptionText(Messages.EDITOR_DESCRIPTION_DEPENDENCIES);
                dependencyDescriptionDecoration.setMarginWidth(1);
                SnippetMetadataPage.this.btnContainerDependencies = managedForm.getToolkit().createComposite(managedForm.getForm().getBody(), 0);
                SnippetMetadataPage.this.btnContainerDependencies.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
                managedForm.getToolkit().paintBordersFor(SnippetMetadataPage.this.btnContainerDependencies);
                SnippetMetadataPage.this.btnContainerDependencies.setLayout((Layout)new GridLayout(1, false));
                SnippetMetadataPage.this.btnAddDependency = managedForm.getToolkit().createButton(SnippetMetadataPage.this.btnContainerDependencies, Messages.EDITOR_BUTTON_ADD_DEPENDENCY, 0);
                SnippetMetadataPage.this.btnAddDependency.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Shell shell = SnippetMetadataPage.this.btnContainerDependencies.getShell();
                        ProjectCoordinateSelectionDialog dialog = new ProjectCoordinateSelectionDialog(shell){
                            private final Set<String> alreadyAddedPcLabels;
                            {
                                this.alreadyAddedPcLabels = Sets.newHashSet();
                            }

                            public String createLabelForProjectCoordinate(ProjectCoordinate element) {
                                return SnippetMetadataPage.this.getStringForDependency(element);
                            }

                            public boolean filter(ProjectCoordinate pc) {
                                for (String dependencylistItem : SnippetMetadataPage.this.fetchDependencyListItems()) {
                                    if (!dependencylistItem.equals(SnippetMetadataPage.this.getStringForDependency(pc))) continue;
                                    return true;
                                }
                                String labelForPc = this.createLabelForProjectCoordinate(pc);
                                if (this.alreadyAddedPcLabels.contains(labelForPc)) {
                                    return true;
                                }
                                this.alreadyAddedPcLabels.add(labelForPc);
                                return false;
                            }
                        };
                        dialog.setInitialPattern("");
                        dialog.setTitle(Messages.DIALOG_TITLE_SELECT_DEPENDENCY);
                        dialog.setMessage(Messages.DIALOG_MESSAGE_SELECT_DEPENDENCY);
                        dialog.open();
                        Set selectedElements = SnippetMetadataPage.this.changeVersionsToZero(dialog.getSelectedElements());
                        SnippetMetadataPage.this.ppDependencies.addAll((Collection)selectedElements);
                    }
                });
                SnippetMetadataPage.this.btnAddDependency.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
                SnippetMetadataPage.this.btnRemoveDependency = managedForm.getToolkit().createButton(SnippetMetadataPage.this.btnContainerDependencies, Messages.EDITOR_BUTTON_REMOVE_TAGS, 0);
                SnippetMetadataPage.this.btnRemoveDependency.setEnabled(false);
                SnippetMetadataPage.this.btnRemoveDependency.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Optional o = Selections.getFirstSelected((Viewer)SnippetMetadataPage.this.listViewerDependencies);
                        if (o.isPresent()) {
                            SnippetMetadataPage.this.ppDependencies.remove(o.get());
                        }
                    }
                });
                SnippetMetadataPage.this.btnRemoveDependency.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
                Label lblUuid = managedForm.getToolkit().createLabel(managedForm.getForm().getBody(), Messages.EDITOR_LABEL_SNIPPET_UUID, 0);
                lblUuid.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
                SnippetMetadataPage.this.txtUuid = managedForm.getToolkit().createText(managedForm.getForm().getBody(), SnippetMetadataPage.this.snippet.getUuid().toString(), 8);
                SnippetMetadataPage.this.txtUuid.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).indent(horizontalIndent, 0).create());
            }

            public void commit(boolean onSave) {
                if (onSave) {
                    super.commit(onSave);
                }
            }

            public void refresh() {
                SnippetMetadataPage.this.context.updateTargets();
                super.refresh();
            }
        };
        managedForm.addPart((IFormPart)this.contentsPart);
        this.context = this.createDataBindingContext();
    }

    private ScrolledForm createHeader(ScrolledForm form) {
        form.setText(Messages.EDITOR_TITLE_METADATA);
        SharedImages sharedImages = (SharedImages)InjectionService.getInstance().getInjector().getInstance(SharedImages.class);
        Action openDiscoveryAction = new Action(Messages.EDITOR_EXTENSIONS_HEADER_EXT_LINK, sharedImages.getDescriptor((SharedImages.ImageResource)SharedImages.Images.ELCL_INSTALL_EXTENSIONS)){

            public void run() {
                SnippetEditorDiscoveryUtils.openDiscoveryDialog();
            }
        };
        EditorUtils.addActionToForm(form, openDiscoveryAction, Messages.EDITOR_EXTENSIONS_HEADER_EXT_LINK);
        Action showHelpAction = new Action(Messages.EDITOR_TOOLBAR_ITEM_HELP, sharedImages.getDescriptor((SharedImages.ImageResource)SharedImages.Images.ELCL_HELP)){

            public void run() {
                BrowserUtils.openInExternalBrowser((String)"http://www.eclipse.org/recommenders/manual/#snippet-editing-sharing");
            }
        };
        EditorUtils.addActionToForm(form, showHelpAction, Messages.EDITOR_TOOLBAR_ITEM_HELP);
        return form;
    }

    private Collection<String> fetchDependencyListItems() {
        final ArrayList items = Lists.newArrayList();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                String[] stringArray = SnippetMetadataPage.this.listViewerDependencies.getList().getItems();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    items.add(string);
                    ++n2;
                }
            }
        });
        return items;
    }

    private Set<ProjectCoordinate> changeVersionsToZero(Set<ProjectCoordinate> resolved) {
        HashSet result = Sets.newHashSet();
        for (ProjectCoordinate projectCoordinate : resolved) {
            result.add(new ProjectCoordinate(projectCoordinate.getGroupId(), projectCoordinate.getArtifactId(), "0.0.0"));
        }
        return result;
    }

    private InputDialog createExtraSearchTermInputDialog(Shell shell) {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                if (Strings.isNullOrEmpty((String)newText)) {
                    return "";
                }
                if (SnippetMetadataPage.this.snippet.getExtraSearchTerms().contains(newText)) {
                    return Messages.DIALOG_VALIDATOR_EXTRA_SEARCH_TERM_ALREADY_ADDED;
                }
                return null;
            }
        };
        return new InputDialog(shell, Messages.DIALOG_TITLE_ENTER_NEW_EXTRA_SEARCH_TERM, Messages.DIALOG_MESSAGE_ENTER_NEW_EXTRA_SEARCH_TERM, "", validator){

            protected void okPressed() {
                SnippetMetadataPage.this.ppExtraSearchTerms.add((Object)this.getValue());
                super.okPressed();
            }
        };
    }

    private InputDialog createTagInputDialog(Shell shell) {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                if (Strings.isNullOrEmpty((String)newText)) {
                    return "";
                }
                if (SnippetMetadataPage.this.snippet.getTags().contains(newText)) {
                    return Messages.DIALOG_VALIDATOR_TAG_ALREADY_ADDED;
                }
                return null;
            }
        };
        return new InputDialog(shell, Messages.DIALOG_TITLE_ENTER_NEW_TAG, Messages.DIALOG_MESSAGE_ENTER_NEW_TAG, "", validator){

            protected void okPressed() {
                SnippetMetadataPage.this.ppTags.add((Object)this.getValue());
                super.okPressed();
            }
        };
    }

    private DataBindingContext createDataBindingContext() {
        DataBindingContext context = new DataBindingContext();
        ISWTObservableValue wpTxtNameText = WidgetProperties.text((int)24).observe((Widget)this.txtName);
        IObservableValue ppName = BeanProperties.value(Snippet.class, (String)"name", String.class).observe((Object)this.snippet);
        context.bindValue((IObservableValue)wpTxtNameText, ppName, null, null);
        ppName.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                if (!SnippetMetadataPage.this.txtName.getText().equals(SnippetMetadataPage.this.snippet.getName())) {
                    SnippetMetadataPage.this.contentsPart.markStale();
                } else {
                    SnippetMetadataPage.this.contentsPart.markDirty();
                }
            }
        });
        ISWTObservableValue wpTxtDescriptionText = WidgetProperties.text((int)24).observe((Widget)this.txtDescription);
        IObservableValue ppDescription = BeanProperties.value(Snippet.class, (String)"description", String.class).observe((Object)this.snippet);
        context.bindValue((IObservableValue)wpTxtDescriptionText, ppDescription, null, null);
        ppDescription.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                if (!SnippetMetadataPage.this.txtDescription.getText().equals(SnippetMetadataPage.this.snippet.getDescription())) {
                    SnippetMetadataPage.this.contentsPart.markStale();
                } else {
                    SnippetMetadataPage.this.contentsPart.markDirty();
                }
            }
        });
        IViewerObservableValue wpTxtLocation = ViewerProperties.singleSelection().observe((Viewer)this.comboLocation);
        IObservableValue ppLocation = BeanProperties.value(Snippet.class, (String)"location", Location.class).observe((Object)this.snippet);
        context.bindValue((IObservableValue)wpTxtLocation, ppLocation);
        ppLocation.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                IStructuredSelection selection = (IStructuredSelection)SnippetMetadataPage.this.comboLocation.getSelection();
                if (!selection.getFirstElement().equals(SnippetMetadataPage.this.snippet.getLocation())) {
                    SnippetMetadataPage.this.contentsPart.markStale();
                } else {
                    SnippetMetadataPage.this.contentsPart.markDirty();
                }
            }
        });
        this.ppExtraSearchTerms = BeanProperties.list(Snippet.class, (String)"extraSearchTerms", String.class).observe((Object)this.snippet);
        ViewerSupport.bind((StructuredViewer)this.listViewerExtraSearchTerms, (IObservableList)this.ppExtraSearchTerms, (IValueProperty)new SelfValueProperty(String.class));
        this.ppExtraSearchTerms.addListChangeListener(new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                if (!Arrays.equals(SnippetMetadataPage.this.listViewerExtraSearchTerms.getList().getItems(), SnippetMetadataPage.this.snippet.getExtraSearchTerms().toArray())) {
                    SnippetMetadataPage.this.contentsPart.markStale();
                } else {
                    SnippetMetadataPage.this.contentsPart.markDirty();
                }
            }
        });
        this.ppTags = BeanProperties.list(Snippet.class, (String)"tags", String.class).observe((Object)this.snippet);
        ViewerSupport.bind((StructuredViewer)this.listViewerTags, (IObservableList)this.ppTags, (IValueProperty)new SelfValueProperty(String.class));
        this.ppTags.addListChangeListener(new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                if (!Arrays.equals(SnippetMetadataPage.this.listViewerTags.getList().getItems(), SnippetMetadataPage.this.snippet.getTags().toArray())) {
                    SnippetMetadataPage.this.contentsPart.markStale();
                } else {
                    SnippetMetadataPage.this.contentsPart.markDirty();
                }
            }
        });
        this.ppDependencies = BeanProperties.set(Snippet.class, (String)"neededDependencies", ProjectCoordinate.class).observe((Object)this.snippet);
        ViewerSupport.bind((StructuredViewer)this.listViewerDependencies, (IObservableSet)this.ppDependencies, (IValueProperty)new SimpleValueProperty(){

            public Object getValueType() {
                return ProjectCoordinate.class;
            }

            protected Object doGetValue(Object source) {
                if (source != null) {
                    ProjectCoordinate pc = (ProjectCoordinate)Checks.cast((Object)source);
                    return SnippetMetadataPage.this.getStringForDependency(pc);
                }
                return "";
            }

            protected void doSetValue(Object source, Object value) {
            }

            public INativePropertyListener adaptListener(ISimplePropertyListener listener) {
                return null;
            }
        });
        this.ppDependencies.addSetChangeListener(new ISetChangeListener(){

            public void handleSetChange(SetChangeEvent event) {
                Set<ProjectCoordinate> pcs = this.convert(SnippetMetadataPage.this.listViewerDependencies.getList().getItems());
                if (!pcs.equals(SnippetMetadataPage.this.snippet.getNeededDependencies())) {
                    SnippetMetadataPage.this.contentsPart.markStale();
                } else {
                    SnippetMetadataPage.this.contentsPart.markDirty();
                }
            }

            private Set<ProjectCoordinate> convert(String[] strings) {
                HashSet result = Sets.newHashSet();
                String[] stringArray = strings;
                int n = strings.length;
                int n2 = 0;
                while (n2 < n) {
                    String projectCoordinate = stringArray[n2];
                    result.add(ProjectCoordinate.valueOf((String)(String.valueOf(projectCoordinate) + ":0.0.0")));
                    ++n2;
                }
                return result;
            }
        });
        ISWTObservableValue wpUuidText = WidgetProperties.text((int)24).observe((Widget)this.txtUuid);
        IObservableValue ppUuid = BeanProperties.value(Snippet.class, (String)"uuid", UUID.class).observe((Object)this.snippet);
        context.bindValue((IObservableValue)wpUuidText, ppUuid, null, null);
        ppUuid.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                if (!SnippetMetadataPage.this.txtUuid.getText().equals(SnippetMetadataPage.this.snippet.getUuid().toString())) {
                    SnippetMetadataPage.this.contentsPart.markStale();
                } else {
                    SnippetMetadataPage.this.contentsPart.markDirty();
                }
            }
        });
        IViewerObservableValue vpExtraSearchTermsSelection = ViewerProperties.singleSelection().observe((Viewer)this.listViewerExtraSearchTerms);
        ISWTObservableValue wpBtnRemoveExtraSearchTermEnable = WidgetProperties.enabled().observe((Widget)this.btnRemoveExtraSearchTerm);
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setConverter((IConverter)new ObjectToBooleanConverter());
        context.bindValue((IObservableValue)vpExtraSearchTermsSelection, (IObservableValue)wpBtnRemoveExtraSearchTermEnable, strategy, null);
        IViewerObservableValue vpTagSelection = ViewerProperties.singleSelection().observe((Viewer)this.listViewerTags);
        ISWTObservableValue wpBtnRemoveTagsEnable = WidgetProperties.enabled().observe((Widget)this.btnRemoveTag);
        context.bindValue((IObservableValue)vpTagSelection, (IObservableValue)wpBtnRemoveTagsEnable, strategy, null);
        IViewerObservableValue vpDependencySelection = ViewerProperties.singleSelection().observe((Viewer)this.listViewerDependencies);
        ISWTObservableValue wpBtnRemoveDependenciesEnable = WidgetProperties.enabled().observe((Widget)this.btnRemoveDependency);
        context.bindValue((IObservableValue)vpDependencySelection, (IObservableValue)wpBtnRemoveDependenciesEnable, strategy, null);
        return context;
    }

    String getStringForDependency(ProjectCoordinate pc) {
        return String.valueOf(pc.getGroupId()) + ":" + pc.getArtifactId();
    }

    public void setFocus() {
        super.setFocus();
        this.txtName.setFocus();
    }

    public void init(IEditorSite site, IEditorInput input) {
        this.snippet = ((SnippetEditorInput)input).getSnippet();
        this.registerEditorInputListener();
        super.init(site, input);
    }

    private void registerEditorInputListener() {
        this.getEditor().addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                if (propId == 258) {
                    SnippetMetadataPage.this.setInputWithNotify(SnippetMetadataPage.this.getEditor().getEditorInput());
                }
            }
        });
    }

    protected void setInputWithNotify(IEditorInput input) {
        this.snippet = ((SnippetEditorInput)input).getSnippet();
        this.context.dispose();
        this.context = this.createDataBindingContext();
        super.setInputWithNotify(input);
    }

    public void dispose() {
        this.context.dispose();
        super.dispose();
    }
}

