/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.e4.launcher.part;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.riena.core.singleton.SingletonProvider;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewId;
import org.eclipse.riena.navigation.ui.swt.views.SubModuleView;
import org.eclipse.swt.widgets.Composite;

public class ViewInstanceProvider {
    private static final SingletonProvider<ViewInstanceProvider> UIS = new SingletonProvider(ViewInstanceProvider.class);
    private final Map<SwtViewId, SubModuleView> views = new HashMap<SwtViewId, SubModuleView>();
    private final Map<SwtViewId, Composite> composites = new HashMap<SwtViewId, Composite>();
    private final Map<SwtViewId, Integer> viewUsage = new HashMap<SwtViewId, Integer>();

    private ViewInstanceProvider() {
    }

    public SubModuleView getView(SwtViewId swtViewId) {
        return this.views.get(swtViewId);
    }

    public Composite getParentComposite(SwtViewId swtViewId) {
        return this.composites.get(swtViewId);
    }

    public void registerView(SwtViewId swtViewId, SubModuleView view) {
        this.views.put(swtViewId, view);
        this.increaseViewCounter(swtViewId);
    }

    public int increaseViewCounter(SwtViewId swtViewId) {
        Integer count = this.viewUsage.get(swtViewId);
        count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
        this.viewUsage.put(swtViewId, count);
        return count;
    }

    public int decreaseViewCounter(SwtViewId swtViewId) {
        Integer count = this.viewUsage.get(swtViewId);
        if (count == null) {
            return -1;
        }
        count = count - 1;
        this.viewUsage.put(swtViewId, count);
        return count;
    }

    public void registerParentComposite(SwtViewId swtViewId, Composite parent) {
        this.composites.put(swtViewId, parent);
    }

    public void unregisterView(SwtViewId swtViewId) {
        this.views.remove(swtViewId);
    }

    public void unregisterTypeId(SwtViewId swtViewId) {
        this.unregisterParentComposite(swtViewId);
        this.unregisterView(swtViewId);
    }

    public void unregisterParentComposite(SwtViewId swtViewId) {
        this.composites.remove(swtViewId);
    }

    public static ViewInstanceProvider getInstance() {
        return (ViewInstanceProvider)UIS.getInstance();
    }
}

