/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.application;

import org.eclipse.riena.ui.swt.lnf.ColorLnfResource;
import org.eclipse.riena.ui.swt.lnf.FontLnfResource;
import org.eclipse.riena.ui.swt.lnf.ILnfCustomizer;
import org.eclipse.riena.ui.swt.lnf.ILnfResource;
import org.eclipse.riena.ui.swt.lnf.ImageLnfResource;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultTheme;

public class ExampleTheme
extends RienaDefaultTheme {
    public void customizeLnf(ILnfCustomizer lnf) {
        super.customizeLnf(lnf);
        this.customizeColors(lnf);
        this.customizeImages(lnf);
        this.customizeFonts(lnf);
        this.customizeSettings(lnf);
    }

    private void customizeColors(ILnfCustomizer lnf) {
        lnf.putLnfResource("TitlelessShell.foreground", (ILnfResource)this.getPrimaryForeground());
        lnf.putLnfResource("ModuleItemToolTip.foreground", (ILnfResource)new ColorLnfResource(64, 0, 64));
        lnf.putLnfResource("SubModuleItemToolTip.foreground", (ILnfResource)new ColorLnfResource(64, 0, 64));
        lnf.putLnfResource("EmbeddedTitlebar.activeBackgroundStartColor", (ILnfResource)new ColorLnfResource(234, 231, 158));
        lnf.putLnfResource("EmbeddedTitlebar.activeBackgroundEndColor", (ILnfResource)new ColorLnfResource(225, 220, 114));
        lnf.putLnfResource("EmbeddedTitlebar.activeBorderColor", (ILnfResource)new ColorLnfResource(171, 171, 174));
        lnf.putLnfResource("EmbeddedTitlebar.passiveBackgroundStartColor", (ILnfResource)new ColorLnfResource(222, 224, 240));
        lnf.putLnfResource("EmbeddedTitlebar.passiveBackgroundEndColor", (ILnfResource)new ColorLnfResource(186, 193, 225));
        lnf.putLnfResource("EmbeddedTitlebar.passiveBorderColor", (ILnfResource)new ColorLnfResource(151, 150, 180));
        lnf.putLnfResource("ModuleGroup.activeBorderColor", (ILnfResource)new ColorLnfResource(255, 200, 15));
        lnf.putLnfResource("Text.background", (ILnfResource)new ColorLnfResource(255, 255, 235));
    }

    private void customizeImages(ILnfCustomizer lnf) {
        String imagePath = "exampleBackground.png";
        lnf.putLnfResource("TitlelessShell.backgroundImage", (ILnfResource)new ImageLnfResource(imagePath));
        imagePath = "exampleRIENA_Logo_RGB.png";
        lnf.putLnfResource("TitlelessShell.logo", (ILnfResource)new ImageLnfResource(imagePath));
        imagePath = "ledred.png";
        lnf.putLnfResource("subModuleTreeDocumentLeaf.icon", (ILnfResource)new ImageLnfResource(imagePath));
        imagePath = "folder_favorite.png";
        lnf.putLnfResource("subModuleTreeFolderClosed.icon", (ILnfResource)new ImageLnfResource(imagePath));
        lnf.putLnfResource("subModuleTreeFolderOpen.icon", (ILnfResource)new ImageLnfResource(imagePath));
        lnf.putLnfResource("workareaTreeFolderOpen.icon", (ILnfResource)new ImageLnfResource(imagePath));
        lnf.putLnfResource("workareaTreeFolderClosed.icon", (ILnfResource)new ImageLnfResource(imagePath));
    }

    private void customizeFonts(ILnfCustomizer lnf) {
        lnf.putLnfResource("TitlelessShell.font", (ILnfResource)new FontLnfResource("Arial", 12, 1));
        lnf.putLnfResource("Dialog.font", (ILnfResource)new FontLnfResource("Arial", 11, 1));
        lnf.putLnfResource("SubApplicationSwitcher.font", (ILnfResource)new FontLnfResource("Arial", 11, 1));
        lnf.putLnfResource("ModuleItemToolTip.font", (ILnfResource)new FontLnfResource("Arial", 11, 1));
        lnf.putLnfResource("SubModuleItem.font", (ILnfResource)new FontLnfResource("Arial", 11, 1));
        lnf.putLnfResource("EmbeddedTitlebar.font", (ILnfResource)new FontLnfResource("Arial", 11, 1));
    }

    private void customizeSettings(ILnfCustomizer lnf) {
        lnf.putLnfSetting("TitlelessShell.verticalLogoPosition", (Object)128);
        lnf.putLnfSetting("TitlelessShell.verticalLogoMargin", (Object)7);
        lnf.putLnfSetting("TitlelessShell.horizontalLogoPosition", (Object)0x1000000);
        lnf.putLnfSetting("SubApplicationSwitcher.horizontalTabPosition", (Object)16384);
        lnf.putLnfSetting("SubApplicationSwitcher.tabShowIcon", (Object)true);
        lnf.putLnfSetting("markerSupport.id", (Object)"defaultMarkerSupport");
    }

    protected ColorLnfResource getPrimaryForeground() {
        return new ColorLnfResource(64, 0, 64);
    }

    protected ColorLnfResource getPrimaryBackground() {
        return new ColorLnfResource(255, 255, 215);
    }

    protected FontLnfResource getPrimaryFont() {
        return new FontLnfResource("Arial", 9, 0);
    }

    protected boolean hideOsBorder() {
        return false;
    }
}

