/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.riena.core.exception.MurphysLawFailure;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.core.uiprocess.IUIProcessChangeListener;
import org.eclipse.riena.ui.core.uiprocess.UIProcess;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;

public class UIProcessDemoSubModuleController
extends SubModuleController {
    private boolean registered;
    private UIProcess process;
    private UIProcess processWithListener;

    public UIProcessDemoSubModuleController() {
        this(null);
    }

    public UIProcessDemoSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
    }

    public IActionRidget getActionRidget() {
        return (IActionRidget)this.getRidget(IActionRidget.class, "actionRidget");
    }

    public IActionRidget getActionRidgetJob() {
        return (IActionRidget)this.getRidget(IActionRidget.class, "actionRidgetJob");
    }

    public IActionRidget getActionRidgetListener() {
        return (IActionRidget)this.getRidget(IActionRidget.class, "actionRidgetListener");
    }

    public void configureRidgets() {
        if (this.getActionRidget() != null && !this.registered) {
            this.initUIProcessAction();
            this.initJobAction();
            this.initListenerAction();
            this.registered = true;
        }
    }

    private void initJobAction() {
        this.getActionRidgetJob().setText("start job");
        this.getActionRidgetJob().addListener((IActionListener)new JobProcessAction());
    }

    private void initUIProcessAction() {
        this.getActionRidget().setText("start UIProcess");
        this.getActionRidget().addListener((IActionListener)new UIProcessAction());
    }

    private void initListenerAction() {
        this.getActionRidgetListener().setText("start with listener");
        this.getActionRidgetListener().addListener((IActionListener)new ListenerAction());
    }

    void runWithListener() {
        boolean addListenerAfterProcessStart = false;
        if (this.processWithListener == null) {
            addListenerAfterProcessStart = true;
            this.processWithListener = new UIProcess("sample uiProcess with listener", true, this.getNavigationNode()){

                public boolean runJob(IProgressMonitor monitor) {
                    return UIProcessDemoSubModuleController.this.doSomeStuff(this, monitor);
                }

                protected int getTotalWork() {
                    return 10;
                }

                public void initialUpdateUI(int totalWork) {
                    System.out.println("UIProcessDemoSubModuleController.runWithListener().new UIProcess() {...}.initialUpdateUI()");
                }

                public void finalUpdateUI() {
                    System.out.println("UIProcessDemoSubModuleController.runWithListener().new UIProcess() {...}.finalUpdateUI()");
                }
            };
            this.processWithListener.addUIProcessChangedListener(new IUIProcessChangeListener(){

                public void afterInitialUpdateUI(int totalWork) {
                    System.out.println("UIProcessDemoSubModuleController.runWithListener().new IUIProcessChangeListener() {...}.afterInitialUpdateUI()  - added before process start");
                }

                public void afterFinalUpdateUI() {
                    System.out.println("UIProcessDemoSubModuleController.runWithListener().new IUIProcessChangeListener() {...}.afterFinalUpdateUI() - added before process start");
                }
            });
            this.processWithListener.setNote("check sysout for listener events");
        }
        this.processWithListener.start();
        if (addListenerAfterProcessStart) {
            this.processWithListener.addUIProcessChangedListener(new IUIProcessChangeListener(){

                public void afterInitialUpdateUI(int totalWork) {
                    System.out.println("UIProcessDemoSubModuleController.runWithListener().new IUIProcessChangeListener() {...}.afterInitialUpdateUI() - added after process start");
                }

                public void afterFinalUpdateUI() {
                    System.out.println("UIProcessDemoSubModuleController.runWithListener().new IUIProcessChangeListener() {...}.afterFinalUpdateUI() - added after process start");
                }
            });
        }
    }

    void runUIProcess() {
        if (this.process == null) {
            this.process = new UIProcess("sample uiProcess", true, this.getNavigationNode()){

                public void initialUpdateUI(int totalWork) {
                    super.initialUpdateUI(totalWork);
                }

                public boolean runJob(IProgressMonitor monitor) {
                    return UIProcessDemoSubModuleController.this.doSomeStuff(this, monitor);
                }

                public void finalUpdateUI() {
                    super.finalUpdateUI();
                    UIProcessDemoSubModuleController.this.setBlocked(false);
                }

                protected int getTotalWork() {
                    return 10;
                }
            };
            this.process.setNote("sample uiProcess note " + ((ISubModuleNode)this.getNavigationNode()).getLabel() + "..");
            this.process.setTitle("sample uiProcess");
            this.process.setCancelEnabled(false);
        }
        if (this.process.start()) {
            this.process.setTitle("sample uiProcess");
        }
    }

    void runJob() {
        Job job = new Job("eclipse job"){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("eclipse job", 10);
                    int i = 0;
                    while (i < 10) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            throw new MurphysLawFailure("Sleeping failed", (Throwable)e);
                        }
                        monitor.worked(1);
                        if (monitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        ++i;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setProperty(UIProcess.PROPERTY_CONTEXT, (Object)this.getNavigationNode());
        job.setUser(true);
        job.schedule();
    }

    private boolean doSomeStuff(UIProcess process, IProgressMonitor monitor) {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            throw new MurphysLawFailure("Sleeping failed", (Throwable)e);
        }
        int i = 0;
        while (i < 10) {
            if (monitor.isCanceled()) {
                monitor.done();
                return false;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new MurphysLawFailure("Sleeping failed", (Throwable)e);
            }
            if (process != null) {
                process.setTitle("sample uiProcess worked [" + i + "]");
            }
            monitor.worked(1);
            ++i;
        }
        return true;
    }

    private class JobProcessAction
    implements IActionListener {
        private JobProcessAction() {
        }

        public void callback() {
            UIProcessDemoSubModuleController.this.runJob();
        }
    }

    private class ListenerAction
    implements IActionListener {
        private ListenerAction() {
        }

        public void callback() {
            UIProcessDemoSubModuleController.this.runWithListener();
        }
    }

    private class UIProcessAction
    implements IActionListener {
        private UIProcessAction() {
        }

        public void callback() {
            UIProcessDemoSubModuleController.this.runUIProcess();
        }
    }
}

