/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.ping.client;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.riena.example.ping.client.controllers.SonarController;
import org.eclipse.riena.example.ping.client.nls.Messages;
import org.eclipse.riena.navigation.ApplicationNodeManager;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.ui.workarea.WorkareaManager;

public class SonarHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        NavigationNodeId navigationNodeId;
        ISubApplicationNode subApplicationNode = ApplicationNodeManager.locateActiveSubApplicationNode();
        INavigationNode node = subApplicationNode.findNode(navigationNodeId = new NavigationNodeId("sonar.submodule", subApplicationNode.getNodeId().getInstanceId()));
        if (node == null) {
            node = this.createPingModuleGroup(subApplicationNode);
        }
        node.activate();
        return null;
    }

    private ISubModuleNode createPingModuleGroup(ISubApplicationNode subApplicationNode) {
        ModuleGroupNode group = new ModuleGroupNode(new NavigationNodeId("sonar.module.group", subApplicationNode.getNodeId().getInstanceId()));
        subApplicationNode.addChild((INavigationNode)group);
        ModuleNode module = new ModuleNode(new NavigationNodeId("sonar.module", subApplicationNode.getNodeId().getInstanceId()), Messages.sonar);
        module.setClosable(true);
        group.addChild((INavigationNode)module);
        SubModuleNode submodule = new SubModuleNode(new NavigationNodeId("sonar.submodule", subApplicationNode.getNodeId().getInstanceId()), null);
        WorkareaManager.getInstance().registerDefinition((INavigationNode)submodule, SonarController.class, (Object)"ping.sonar.view", false);
        module.addChild((INavigationNode)submodule);
        return submodule;
    }
}

