/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.sample.snippets;

import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.riena.ui.ridgets.ILabelRidget;
import org.eclipse.riena.ui.ridgets.swt.SwtRidgetFactory;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public final class SnippetLabelRidget001 {
    public static void main(String[] args) {
        Display display = Display.getDefault();
        try {
            Shell shell = UIControlsFactory.createShell((Display)display);
            GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).spacing(20, 10).applyTo((Composite)shell);
            UIControlsFactory.createLabel((Composite)shell, (String)"DateTime:");
            Label dateTimeWidget = UIControlsFactory.createLabel((Composite)shell, (String)"");
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)dateTimeWidget);
            final DatePojo datePojo = new DatePojo();
            final ILabelRidget dateTimeRidget = (ILabelRidget)SwtRidgetFactory.createRidget((Object)dateTimeWidget);
            dateTimeRidget.bindToModel(PojoObservables.observeValue((Object)datePojo, (String)"time"));
            final Timer t = new Timer();
            try {
                TimerTask task = new TimerTask(){

                    @Override
                    public void run() {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    datePojo.update();
                                    dateTimeRidget.updateFromModel();
                                }
                                catch (SWTException sWTException) {
                                    t.cancel();
                                }
                            }
                        });
                    }
                };
                t.schedule(task, new Date(), 1000L);
                shell.setSize(300, 100);
                shell.open();
                while (!shell.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
            finally {
                t.cancel();
            }
        }
        finally {
            display.dispose();
        }
    }

    private static class DatePojo {
        private Date time;

        DatePojo() {
            this.update();
        }

        public void update() {
            this.time = Calendar.getInstance().getTime();
        }

        public Date getTime() {
            return this.time;
        }
    }
}

