/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.riena.core.util.ObjectUtils;
import org.eclipse.riena.ui.ridgets.IMasterDetailsRidget;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractMasterDetailsRidget;
import org.eclipse.riena.ui.swt.MasterDetailsComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;

public class MasterDetailsRidget
extends AbstractMasterDetailsRidget
implements IMasterDetailsRidget {
    private final DirtyDetailsChecker dirtyDetailsChecker = new DirtyDetailsChecker();

    public MasterDetailsComposite getUIControl() {
        return (MasterDetailsComposite)super.getUIControl();
    }

    @Override
    protected void checkUIControl(Object uiControl) {
        super.checkUIControl(uiControl);
        this.checkType(uiControl, MasterDetailsComposite.class);
    }

    protected void bindUIControl() {
        MasterDetailsComposite control = this.getUIControl();
        if (control != null) {
            Table table = control.getTable();
            table.addSelectionListener((SelectionListener)this.dirtyDetailsChecker);
        }
    }

    protected void unbindUIControl() {
        MasterDetailsComposite control = this.getUIControl();
        if (control != null) {
            Table table = control.getTable();
            table.removeSelectionListener((SelectionListener)this.dirtyDetailsChecker);
        }
    }

    @Override
    protected final void bindTableToModel(IObservableList rowObservables, Class<? extends Object> rowClass, String[] columnPropertyNames, String[] columnHeaders) {
        this.getTableRidget().bindToModel(rowObservables, rowClass, columnPropertyNames, columnHeaders);
    }

    @Override
    protected void configureTableRidget() {
    }

    @Override
    protected final void setTableSelection(Object value) {
        this.getTableRidget().setSelection(value);
    }

    @Override
    protected final Object getTableSelection() {
        List selection = this.getTableRidget().getSelection();
        return selection.isEmpty() ? null : selection.get(0);
    }

    @Override
    protected final IObservableValue getSelectionObservable() {
        return this.getTableRidget().getSingleSelectionObservable();
    }

    @Override
    protected final void revealTableSelection() {
        this.getUIControl().getTable().showSelection();
    }

    @Override
    protected final void clearTableSelection() {
        this.dirtyDetailsChecker.clearSavedSelection();
        this.getTableRidget().clearSelection();
    }

    private ITableRidget getTableRidget() {
        return (ITableRidget)this.getRidget(ITableRidget.class, "mdTable");
    }

    @Override
    public void handleApply() {
        super.handleApply();
        Table table = this.getUIControl().getTable();
        if (table.getItemCount() == 1) {
            this.getTableRidget().clearSelection();
        } else {
            table.select(table.getSelectionIndex());
        }
        table.setFocus();
    }

    @Override
    public void updateFromModel() {
        Object oldSelection = this.getTableSelection();
        super.updateFromModel();
        Object tableSelection = this.getTableSelection();
        if (!ObjectUtils.equals((Object)oldSelection, (Object)tableSelection)) {
            this.handleSelectionChange(tableSelection);
        } else if (tableSelection != null) {
            this.updateDetails(tableSelection);
        }
        if (this.dirtyDetailsChecker != null) {
            this.dirtyDetailsChecker.clearSavedSelection();
        }
    }

    private final class DirtyDetailsChecker
    extends SelectionAdapter {
        private int oldIndex = -1;
        private Object oldSelection = new Object();

        private DirtyDetailsChecker() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object newSelection = e.item.getData();
            Table table = (Table)e.widget;
            if (this.oldIndex == table.getSelectionIndex() || this.oldSelection.equals(newSelection)) {
                return;
            }
            if (MasterDetailsRidget.this.areDetailsChanged() && !MasterDetailsRidget.this.getUIControl().confirmDiscardChanges()) {
                table.setSelection(this.oldIndex);
                return;
            }
            this.oldIndex = table.getSelectionIndex();
            this.oldSelection = newSelection;
            MasterDetailsRidget.this.handleSelectionChange(newSelection);
        }

        void clearSavedSelection() {
            this.oldIndex = -1;
            this.oldSelection = new Object();
        }
    }
}

