/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt.views;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.window.Window;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.controller.AbstractWindowController;
import org.eclipse.riena.ui.ridgets.swt.views.AbstractControlledView;
import org.eclipse.riena.ui.ridgets.swt.views.BlockHelper;
import org.eclipse.riena.ui.ridgets.swt.views.DialogStatuslineContentFactory;
import org.eclipse.riena.ui.swt.GrabCorner;
import org.eclipse.riena.ui.swt.IStatusLineContentFactory;
import org.eclipse.riena.ui.swt.RienaWindowRenderer;
import org.eclipse.riena.ui.swt.Statusline;
import org.eclipse.riena.ui.swt.StatuslineSpacer;
import org.eclipse.riena.ui.swt.layout.DpiGridLayoutFactory;
import org.eclipse.riena.ui.swt.lnf.LnFUpdater;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.SWTControlFinder;
import org.eclipse.riena.ui.swt.utils.ShellHelper;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractDialogView
extends Dialog {
    private static final LnFUpdater LNF_UPDATER = LnFUpdater.getInstance();
    @Deprecated
    public static final String STATUSLINE_BINDING_ID = "dlg_statusline";
    private final RienaWindowRenderer dlgRenderer;
    private final ControlledView controlledView;
    private String title;
    private boolean isClosing;
    private final boolean statusLine;
    private final BlockHelper blockHelper;

    private static Shell getShellByGuessing() {
        if (PlatformUI.isWorkbenchRunning()) {
            IWorkbenchWindow activeWorkbenchWindow;
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null && (activeWorkbenchWindow = workbench.getActiveWorkbenchWindow()) != null) {
                return activeWorkbenchWindow.getShell();
            }
        } else if (Display.getCurrent() != null) {
            return Display.getCurrent().getActiveShell();
        }
        return null;
    }

    protected AbstractDialogView(Shell parentShell, boolean statusLine) {
        super(parentShell != null ? parentShell : AbstractDialogView.getShellByGuessing());
        this.statusLine = statusLine;
        this.title = "";
        this.dlgRenderer = new RienaWindowRenderer((Window)this, this.isPaintTitlebar());
        this.controlledView = new ControlledView();
        AbstractWindowController controller = this.createController();
        this.blockHelper = new BlockHelper(){

            @Override
            protected boolean shouldRestoreFocus() {
                return true;
            }

            @Override
            protected Control getParentComposite() {
                return AbstractDialogView.this.getContents();
            }

            @Override
            protected IRidget getFocusRidget() {
                return null;
            }

            @Override
            protected IRidgetContainer getController() {
                return AbstractDialogView.this.getController();
            }
        };
        controller.setBlocker((AbstractWindowController.Blocker)this.blockHelper);
        this.controlledView.setController(controller);
    }

    protected AbstractDialogView(Shell parentShell) {
        this(parentShell, false);
    }

    protected boolean isPaintTitlebar() {
        return true;
    }

    public void create() {
        this.setShellStyle(this.dlgRenderer.computeShellStyle());
        super.create();
        this.applyTitle(this.getShell());
        this.addUIControls((Composite)this.getShell());
        LNF_UPDATER.updateUIControlColors((Composite)this.getShell());
        this.bindController();
        LNF_UPDATER.updateUIControls((Composite)this.getShell(), true);
        this.initializeBounds();
        ShellHelper.center((Shell)this.getShell());
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!AbstractDialogView.this.isClosing) {
                    AbstractDialogView.this.close();
                } else {
                    AbstractWindowController controller = AbstractDialogView.this.getController();
                    controller.setReturnCode(1);
                    AbstractDialogView.this.setReturnCode(controller.getReturnCode());
                }
                AbstractDialogView.this.isClosing = false;
            }
        });
        this.getShell().setMinimumSize(100, 50);
    }

    public boolean close() {
        if (this.blockHelper.isBlocked()) {
            return false;
        }
        AbstractWindowController controller = this.getController();
        this.isClosing = true;
        this.setReturnCode(controller.getReturnCode());
        this.controlledView.unbind(controller);
        return super.close();
    }

    public final AbstractWindowController getController() {
        return (AbstractWindowController)this.controlledView.getController();
    }

    public void setDefaultButton(Button defaultButton) {
        this.getShell().setDefaultButton(defaultButton);
    }

    public final void setTitle(String title) {
        Assert.isNotNull((Object)title);
        this.title = title;
    }

    @Deprecated
    public final void build() {
        this.open();
    }

    protected final void addUIControl(Object uiControl, String bindingId) {
        this.controlledView.addUIControl(uiControl, bindingId);
    }

    protected final Control createButtonBar(Composite parent) {
        return this.dlgRenderer.createButtonBar(parent);
    }

    protected final Control createContents(Composite parent) {
        Control result = this.dlgRenderer.createContents(parent);
        super.createContents(this.dlgRenderer.getCenterComposite());
        return result;
    }

    protected final Control createDialogArea(Composite parent) {
        Composite mainComposite = this.createMainComposite(parent);
        int lineRightOffset = 0;
        if (this.isResizable() && this.isHideOsBorder() && this.isPaintTitlebar()) {
            GrabCorner grabCorner = new GrabCorner(mainComposite, mainComposite.getStyle());
            lineRightOffset = grabCorner.getGrabCornerSize().x;
        }
        if (this.statusLine) {
            Statusline line = new Statusline(mainComposite, 0, StatuslineSpacer.class, this.getStatusLineContentFacroty());
            FormData lineFormData = new FormData();
            lineFormData.height = this.getStatuslineHeight();
            lineFormData.bottom = new FormAttachment(100, 0);
            lineFormData.right = new FormAttachment(100, -lineRightOffset);
            lineFormData.left = new FormAttachment(0, 0);
            line.setLayoutData((Object)lineFormData);
            this.addUIControl(line, STATUSLINE_BINDING_ID);
        }
        this.createContentComposite(mainComposite);
        this.blockHelper.registerOnContentComposite(parent);
        return mainComposite;
    }

    private Integer getStatuslineHeight() {
        if (this.statusLine) {
            return LnfManager.getLnf().getIntegerSetting("dialog.statusline.height");
        }
        return 0;
    }

    protected void createOkCancelButtons(Composite parent) {
    }

    private Composite createMainComposite(Composite parent) {
        Composite mainComposite = UIControlsFactory.createComposite((Composite)parent, (int)parent.getStyle());
        mainComposite.setBackground(parent.getBackground());
        mainComposite.setLayout((Layout)new FormLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)mainComposite);
        return mainComposite;
    }

    private void createContentComposite(Composite parent) {
        Composite mainContentComposite = UIControlsFactory.createComposite((Composite)parent, (int)parent.getStyle());
        DpiGridLayoutFactory.fillDefaults().applyTo(mainContentComposite);
        Composite contentComposite = UIControlsFactory.createComposite((Composite)mainContentComposite, (int)parent.getStyle());
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)contentComposite);
        DpiGridLayoutFactory.fillDefaults().applyTo(contentComposite);
        this.buildView(contentComposite);
        this.addUIControl(this.getShell(), "windowRidget");
        FormData resultFormData = new FormData();
        resultFormData.top = new FormAttachment(0, 0);
        resultFormData.left = new FormAttachment(0, 0);
        resultFormData.right = new FormAttachment(100, 0);
        resultFormData.bottom = new FormAttachment(100, -this.getStatuslineHeight().intValue());
        mainContentComposite.setLayoutData((Object)resultFormData);
        this.createOkCancelButtons(mainContentComposite);
    }

    protected boolean isResizable() {
        return (this.getShellStyle() & 0x10) == 16;
    }

    private boolean isHideOsBorder() {
        return LnfManager.getLnf().getBooleanSetting("Dialog.hideOsBorder");
    }

    protected IStatusLineContentFactory getStatusLineContentFacroty() {
        return new DialogStatuslineContentFactory();
    }

    protected abstract Control buildView(Composite var1);

    protected abstract AbstractWindowController createController();

    private void applyTitle(Shell shell) {
        if (shell.getText().length() == 0) {
            shell.setText(this.title);
        }
    }

    private void addUIControls(Composite composite) {
        SWTControlFinder finder = new SWTControlFinder(composite){

            public void handleBoundControl(Control control, String bindingProperty) {
                AbstractDialogView.this.addUIControl(control, bindingProperty);
            }
        };
        finder.run();
    }

    private void bindController() {
        this.controlledView.initialize(this.getController());
        this.controlledView.bind(this.getController());
    }

    private static final class ControlledView
    extends AbstractControlledView<AbstractWindowController> {
        private ControlledView() {
        }

        @Override
        protected void addUIControl(Object uiControl, String propertyName) {
            super.addUIControl(uiControl, propertyName);
        }

        @Override
        protected void setController(AbstractWindowController controller) {
            super.setController(controller);
        }
    }
}

