/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import java.util.EventListener;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.renderer.DialogBorderRenderer;
import org.eclipse.riena.ui.swt.utils.ImageStore;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class GrabCorner
extends Composite {
    private final boolean isMainShell;

    public GrabCorner(Composite parent, int style) {
        this(parent, style, parent instanceof Shell);
    }

    public GrabCorner(Composite parent, int style, boolean isOnMainWindow) {
        super(parent, style);
        this.isMainShell = isOnMainWindow;
        this.setBackground(parent.getBackground());
        this.setData("sizeexecutor", "grabcorner");
        if (isOnMainWindow) {
            this.setLayoutData();
        } else {
            this.setDialogLayoutData();
        }
        SWTFacade facade = SWTFacade.getDefault();
        facade.addPaintListener((Control)this, (EventListener)((Object)new GrabPaintListener()));
        facade.createGrabCornerListenerWithTracker((Control)this);
    }

    private void setLayoutData() {
        Point grabCornerSize = this.getGrabCornerSize();
        int borderWidth = GrabCorner.getShellBorderWidth();
        FormData grabFormData = new FormData();
        grabFormData.width = grabCornerSize.y;
        grabFormData.height = grabCornerSize.x;
        grabFormData.bottom = new FormAttachment(100, -borderWidth);
        grabFormData.right = new FormAttachment(100, -borderWidth);
        this.setLayoutData(grabFormData);
    }

    private void setDialogLayoutData() {
        Point grabCornerSize = this.getGrabCornerSize();
        FormData grabFormData = new FormData();
        grabFormData.width = grabCornerSize.x;
        grabFormData.height = grabCornerSize.y;
        grabFormData.bottom = new FormAttachment(100, 0);
        grabFormData.right = new FormAttachment(100, 0);
        this.setLayoutData(grabFormData);
    }

    public Point getGrabCornerSize() {
        Point grabCornerSize = new Point(GrabCorner.getShellBorderWidth(), GrabCorner.getShellBorderWidth());
        Image grabCorner = this.getGrabCornerImage();
        if (grabCorner != null) {
            if (!this.isMainShell) {
                grabCornerSize = new Point(grabCorner.getBounds().width, grabCorner.getBounds().height);
            } else {
                Rectangle imageBounds = grabCorner.getBounds();
                int width = grabCornerSize.x + imageBounds.width;
                int height = grabCornerSize.y + imageBounds.height;
                grabCornerSize = new Point(width, height);
            }
        }
        return grabCornerSize;
    }

    public static boolean isResizeable() {
        return LnfManager.getLnf().getBooleanSetting("TitlelessShell.resizeable", true);
    }

    private Image getGrabCornerImage() {
        Image image = LnfManager.getLnf().getImage(this.isMainShell ? "TitlelessShell.grabCornerImage" : "Dialog.grabCornerImage");
        if (image == null) {
            image = ImageStore.getInstance().getMissingImage();
        }
        return image;
    }

    private static int getShellBorderWidth() {
        DialogBorderRenderer borderRenderer = (DialogBorderRenderer)LnfManager.getLnf().getRenderer("TitlelessShell.borderRenderer");
        return borderRenderer != null ? borderRenderer.getBorderWidth() : 0;
    }

    private class GrabPaintListener
    implements PaintListener {
        private GrabPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            GC gc = e.gc;
            Image grabCornerImage = GrabCorner.this.getGrabCornerImage();
            if (grabCornerImage != null) {
                gc.drawImage(grabCornerImage, 0, 0);
            }
        }
    }
}

