/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml.schema;

import java.io.File;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.modeling.xml.dtd.DtdParser;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchema;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchemaParser;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;

public final class XmlDocumentSchemasCache {
    private static final XmlDocumentSchema EMPTY_SCHEMA = new XmlDocumentSchema.Factory().create();
    private static final Map<String, SoftReference<XmlDocumentSchema>> cache = new HashMap<String, SoftReference<XmlDocumentSchema>>();

    public static XmlDocumentSchema getSchema(String location) {
        return XmlDocumentSchemasCache.getSchema(null, null, location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XmlDocumentSchema getSchema(final String referer, String publicId, String systemId) {
        URL url;
        String location;
        block22: {
            if (publicId == null && systemId == null) {
                throw new IllegalArgumentException();
            }
            location = URIResolverPlugin.createResolver().resolve(referer, publicId, systemId);
            if (location == null) {
                if (systemId != null) {
                    location = systemId;
                } else if (publicId != null && !publicId.startsWith("-//")) {
                    location = publicId;
                }
            }
            if (location == null) {
                return EMPTY_SCHEMA;
            }
            url = null;
            try {
                url = new URL(location);
            }
            catch (MalformedURLException malformedURLException) {
                if (referer == null) break block22;
                try {
                    url = new File(new File(referer).getParentFile(), location).toURI().toURL();
                    location = url.toString();
                }
                catch (MalformedURLException malformedURLException2) {}
            }
        }
        if (url == null) {
            return EMPTY_SCHEMA;
        }
        XmlDocumentSchema schema = null;
        Class<XmlDocumentSchemasCache> clazz = XmlDocumentSchemasCache.class;
        synchronized (XmlDocumentSchemasCache.class) {
            SoftReference<XmlDocumentSchema> ref = cache.get(location);
            if (ref != null && (schema = ref.get()) == null) {
                cache.remove(location);
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            if (schema != null) return schema;
            try {
                if (location.endsWith("dtd")) {
                    schema = DtdParser.parse(url);
                } else {
                    XmlDocumentSchemaParser.Resolver resolver = new XmlDocumentSchemaParser.Resolver(){

                        @Override
                        public URL resolve(String location) {
                            URL schemaLocationUrl;
                            block5: {
                                schemaLocationUrl = null;
                                try {
                                    schemaLocationUrl = new URL(URIResolverPlugin.createResolver().resolve(referer, null, location));
                                }
                                catch (MalformedURLException malformedURLException) {
                                    if (referer == null) break block5;
                                    try {
                                        schemaLocationUrl = new File(new File(referer).getParentFile(), location).toURI().toURL();
                                    }
                                    catch (MalformedURLException ex) {
                                        throw new RuntimeException(ex);
                                    }
                                }
                            }
                            if (schemaLocationUrl == null) {
                                throw new IllegalArgumentException();
                            }
                            return schemaLocationUrl;
                        }
                    };
                    schema = XmlDocumentSchemaParser.parse(url, systemId, resolver);
                }
            }
            catch (Exception e) {
                ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                schema = EMPTY_SCHEMA;
            }
            clazz = XmlDocumentSchemasCache.class;
            synchronized (XmlDocumentSchemasCache.class) {
                ref = new SoftReference<XmlDocumentSchema>(schema);
                cache.put(location, ref);
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return schema;
            }
        }
    }
}

