/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el.internal;

import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;

public final class EncodeToXmlFunction
extends Function {
    private static final char[] ESCAPE_CHARS = new char[]{'<', '>', '&', '\"', '\''};
    private static final String[] ESCAPE_STRINGS = new String[]{"&lt;", "&gt;", "&amp;", "&quot;", "&apos;"};

    @Override
    public String name() {
        return "EncodeToXml";
    }

    @Override
    public FunctionResult evaluate(FunctionContext context) {
        return new FunctionResult(this, context){

            @Override
            protected Object evaluate() {
                String string = this.cast(this.operand(0), String.class);
                boolean needToEncode = false;
                int i = 0;
                int n = string.length();
                while (i < n && !needToEncode) {
                    char ch = string.charAt(i);
                    int j = 0;
                    while (j < ESCAPE_CHARS.length && !needToEncode) {
                        if (ch == ESCAPE_CHARS[j]) {
                            needToEncode = true;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (needToEncode) {
                    StringBuilder buf = new StringBuilder();
                    int i2 = 0;
                    int n2 = string.length();
                    while (i2 < n2) {
                        char ch = string.charAt(i2);
                        boolean encoded = false;
                        int j = 0;
                        while (j < ESCAPE_CHARS.length && !encoded) {
                            if (ch == ESCAPE_CHARS[j]) {
                                buf.append(ESCAPE_STRINGS[j]);
                                encoded = true;
                            }
                            ++j;
                        }
                        if (!encoded) {
                            buf.append(ch);
                        }
                        ++i2;
                    }
                    return buf.toString();
                }
                return string;
            }
        };
    }
}

