/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.modeling.util.MiscUtil;

public final class PossibleTypesServiceData {
    private static final Comparator<ElementType> COMPARATOR = new Comparator<ElementType>(){

        @Override
        public int compare(ElementType x, ElementType y) {
            return x.getSimpleName().compareTo(y.getSimpleName());
        }
    };
    private final SortedSet<ElementType> types;

    public PossibleTypesServiceData(Collection<ElementType> types) {
        TreeSet<ElementType> clean = new TreeSet<ElementType>(COMPARATOR);
        for (ElementType type : types) {
            if (type == null) continue;
            clean.add(type);
        }
        this.types = Collections.unmodifiableSortedSet(clean);
    }

    public PossibleTypesServiceData(ElementType ... types) {
        this(MiscUtil.list(types));
    }

    public SortedSet<ElementType> types() {
        return this.types;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PossibleTypesServiceData) {
            PossibleTypesServiceData data = (PossibleTypesServiceData)obj;
            return this.types.equals(data.types);
        }
        return false;
    }

    public int hashCode() {
        return this.types.hashCode();
    }
}

