/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms;

import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.PossibleValues;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Image;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;
import org.eclipse.sapphire.ui.def.HorizontalAlignment;
import org.eclipse.sapphire.ui.def.ImageReference;
import org.eclipse.sapphire.ui.forms.FormComponentDef;

@Label(standard="actuator")
@Image(path="ActuatorDef.png")
@XmlBinding(path="actuator")
@Documentation(content="An actuator provides means to invoke an action. The action could be drawn from the context where actuator is placed or provided as part of actuator's definition.")
public interface ActuatorDef
extends FormComponentDef {
    public static final ElementType TYPE = new ElementType(ActuatorDef.class);
    @Label(standard="action ID")
    @Required
    @XmlBinding(path="action-id")
    public static final ValueProperty PROP_ACTION_ID = new ValueProperty(TYPE, "ActionId");
    @Label(standard="action handler ID")
    @XmlBinding(path="action-handler-id")
    public static final ValueProperty PROP_ACTION_HANDLER_ID = new ValueProperty(TYPE, "ActionHandlerId");
    @Type(base=Boolean.class)
    @Label(standard="show label")
    @DefaultValue(text="true")
    @XmlBinding(path="show-label")
    @Documentation(content="Indicates whether a label should be shown when presenting the actuator. By default, the label associated with the linked action will be used. Alternatively, a label can be specified explicitly.")
    public static final ValueProperty PROP_SHOW_LABEL = new ValueProperty(TYPE, "ShowLabel");
    @Type(base=Function.class)
    @Label(standard="label")
    @Enablement(expr="${ ShowLabel }")
    @XmlBinding(path="label")
    @Documentation(content="The label to use when presenting the actuator. If not specified, the label associated with the linked action will be used.")
    public static final ValueProperty PROP_LABEL = new ValueProperty(TYPE, "Label");
    @Type(base=Boolean.class)
    @Label(standard="show image")
    @DefaultValue(text="false")
    @XmlBinding(path="show-image")
    @Documentation(content="Indicates whether an image should be shown when presenting the actuator. By default, the image associated with the linked action will be used. Alternatively, an image can be specified explicitly.")
    public static final ValueProperty PROP_SHOW_IMAGE = new ValueProperty(TYPE, "ShowImage");
    @Type(base=ImageReference.class)
    @Label(standard="images")
    @Enablement(expr="${ ShowImage }")
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="image", type=ImageReference.class)})
    @Documentation(content="The image to use when presenting the actuator. If not specified, the image associated with the linked action will be used.")
    public static final ListProperty PROP_IMAGES = new ListProperty(TYPE, "Images");
    @DefaultValue(text="Sapphire.Actuator.Link")
    @PossibleValues(values={"Sapphire.Actuator.Link", "Sapphire.Actuator.Button"})
    public static final ValueProperty PROP_STYLE = new ValueProperty(TYPE, FormComponentDef.PROP_STYLE);
    @Type(base=HorizontalAlignment.class)
    @Label(standard="horizontal alignment")
    @DefaultValue(text="left")
    @XmlBinding(path="horizontal-align")
    public static final ValueProperty PROP_HORIZONTAL_ALIGNMENT = new ValueProperty(TYPE, "HorizontalAlignment");
    @Type(base=Boolean.class)
    @Label(standard="span both columns")
    @DefaultValue(text="true")
    @XmlBinding(path="span")
    @Documentation(content="Indicates whether the actuator should span both columns. Note that depending on presentation details the actuator may not stretch horizontally, but the choice of whether to span both columns interracts with horizontal alignment selection to determine exactly where the actuator will be placed.")
    public static final ValueProperty PROP_SPAN_BOTH_COLUMNS = new ValueProperty(TYPE, "SpanBothColumns");

    public Value<String> getActionId();

    public void setActionId(String var1);

    public Value<String> getActionHandlerId();

    public void setActionHandlerId(String var1);

    public Value<Boolean> getShowLabel();

    public void setShowLabel(String var1);

    public void setShowLabel(Boolean var1);

    public Value<Function> getLabel();

    public void setLabel(String var1);

    public void setLabel(Function var1);

    public Value<Boolean> getShowImage();

    public void setShowImage(String var1);

    public void setShowImage(Boolean var1);

    public ElementList<ImageReference> getImages();

    public Value<HorizontalAlignment> getHorizontalAlignment();

    public void setHorizontalAlignment(String var1);

    public void setHorizontalAlignment(HorizontalAlignment var1);

    public Value<Boolean> getSpanBothColumns();

    public void setSpanBothColumns(String var1);

    public void setSpanBothColumns(Boolean var1);
}

